<?php

namespace App\Http\Controllers;

use App\Models\Attendance;
use App\Models\User;
use Illuminate\Http\Request;

class AttendanceController extends Controller
{
    // Display a listing of attendance records.
    public function index()
    {
        $attendances = Attendance::with('user')->get();
        $users = User::all();
        return view('attendance', compact('attendances', 'users'));
    }

    public function create(Request $request)
    {
        $leave = new Attendance();
        $leave->user_id = $request->user_id;
        $leave->start = $request->start;
        $leave->location = $request->location;
        $leave->description = $request->description;
        $leave->save();
        return redirect()->route('attendance');
    }

    // Store a newly created attendance record in storage.
    public function store(Request $request)
    {
        $request->validate([
            'user_id' => 'required|exists:users,id',
            'check_in' => 'required|date',
            'check_out' => 'nullable|date|after:check_in',
            'status' => 'required|string',
        ]);

        Attendance::create($request->all());

        return redirect()->route('attendances.index')->with('success', 'Attendance recorded successfully.');
    }

    // Display the specified attendance record.
    public function show(Attendance $attendance)
    {
        return view('attendances.show', compact('attendance'));
    }

    // Show the form for editing the specified attendance record.
    public function edit(Attendance $attendance)
    {
        $users = User::all();
        return view('attendances.edit', compact('attendance', 'users'));
    }

    // Update the specified attendance record in storage.
    public function update(Request $request, Attendance $attendance)
    {
        $request->validate([
            'user_id' => 'required|exists:users,id',
            'check_in' => 'required|date',
            'check_out' => 'nullable|date|after:check_in',
            'status' => 'required|string',
        ]);

        $attendance->update($request->all());

        return redirect()->route('attendances.index')->with('success', 'Attendance updated successfully.');
    }

    // Remove the specified attendance record from storage.
    public function destroy(Attendance $attendance)
    {
        $attendance->delete();

        return redirect()->route('attendances.index')->with('success', 'Attendance deleted successfully.');
    }
}
