<?php

namespace App\Http\Controllers;

use App\Models\Leave;
use App\Models\LeaveType;
use App\Models\User;
use Illuminate\Http\Request;

class LeaveController extends Controller
{
    public function index()
    {
        $leaves = Leave::with(['user', 'leave_type'])->get();
        $users = User::all();
        $leave_type = LeaveType::all();
        return view('leave', compact('leaves', 'users', 'leave_type'));
    }

    public function create(Request $request)
    {
        $leave = new Leave();
        $leave->user_id = $request->user_id;
        $leave->leave_type_id = $request->leave_type_id;
        $leave->start = $request->start;
        $leave->end = $request->end;
        $leave->reason = $request->reason;
        $leave->save();
        return redirect()->route('leave');
    }
}
