<?php

namespace App\Http\Controllers;

use App\Models\Overtime;
use App\Models\User;
use Illuminate\Http\Request;

class OvertimeController extends Controller
{
    public function index()
    {
        $overtimes = Overtime::with('user')->get();
        $users = User::all();
        return view('overtime', compact('overtimes', 'users'));
    }


    public function create(Request $request)
    {
        $overtime = new Overtime();
        $overtime->user_id = $request->user_id;
        $overtime->start = $request->start;
        $overtime->end = $request->end;
        $overtime->description = $request->description;
        $overtime->location = $request->location;
        $overtime->save();
        return redirect()->route('overtime');
    }

    // Store a newly created overtime record in storage.
    public function store(Request $request)
    {
        $request->validate([
            'user_id' => 'required|exists:users,id',
            'date' => 'required|date',
            'start_time' => 'required|date_format:H:i',
            'end_time' => 'required|date_format:H:i|after:start_time',
            'reason' => 'required|string',
        ]);

        Overtime::create($request->all());

        return redirect()->route('overtimes.index')->with('success', 'Overtime recorded successfully.');
    }

    // Display the specified overtime record.
    public function show(Overtime $overtime)
    {
        return view('overtimes.show', compact('overtime'));
    }

    // Show the form for editing the specified overtime record.
    public function edit(Overtime $overtime)
    {
        $users = User::all();
        return view('overtimes.edit', compact('overtime', 'users'));
    }

    // Update the specified overtime record in storage.
    public function update(Request $request, Overtime $overtime)
    {
        $request->validate([
            'user_id' => 'required|exists:users,id',
            'date' => 'required|date',
            'start_time' => 'required|date_format:H:i',
            'end_time' => 'required|date_format:H:i|after:start_time',
            'reason' => 'required|string',
        ]);

        $overtime->update($request->all());

        return redirect()->route('overtimes.index')->with('success', 'Overtime updated successfully.');
    }

    // Remove the specified overtime record from storage.
    public function destroy(Overtime $overtime)
    {
        $overtime->delete();

        return redirect()->route('overtimes.index')->with('success', 'Overtime deleted successfully.');
    }
}
