<?php

namespace App\Http\Controllers;

use App\Models\Request as ModelsRequest;
use App\Models\RequestModel; // Adjust the model name if different
use App\Models\RequestType;
use App\Models\User;
use Illuminate\Http\Request;

class RequestController extends Controller
{
    // Display a listing of requests.
    public function index()
    {
        $requests = ModelsRequest::with(['user','request_type'])->get();
        $users = User::all();
        $request_type = RequestType::all();
        return view('request', compact('requests', 'users', 'request_type'));
    }

    public function create(Request $request)
    {
        $model_request = new ModelsRequest();
        $model_request->user_id = $request->user_id;
        $model_request->request_type_id = $request->request_type_id;
        $model_request->start = $request->start;
        $model_request->end = $request->end;
        $model_request->description = $request->description;
        $model_request->location = $request->location;
        $model_request->save();
        return redirect()->route('request');
    }

    // Store a newly created request in storage.
    public function store(Request $request)
    {
        $request->validate([
            'type' => 'required|string',
            'description' => 'required|string',
            'date' => 'required|date',
            'status' => 'required|string',
            'user_id' => 'required|exists:users,id',
        ]);

        ModelsRequest::create($request->all());

        return redirect()->route('requests.index')->with('success', 'Request created successfully.');
    }

    // Display the specified request.
    public function show(Request $request)
    {
        return view('requests.show', compact('request'));
    }

    // Show the form for editing the specified request.
    public function edit(Request $request)
    {
        return view('requests.edit', compact('request'));
    }

    // Update the specified request in storage.
    public function update(Request $request, ModelsRequest $requestModel)
    {
        $request->validate([
            'type' => 'required|string',
            'description' => 'required|string',
            'date' => 'required|date',
            'status' => 'required|string',
        ]);

        $requestModel->update($request->all());

        return redirect()->route('requests.index')->with('success', 'Request updated successfully.');
    }

    // Remove the specified request from storage.
    public function destroy(Request $requestModel)
    {
        $requestModel->delete();

        return redirect()->route('requests.index')->with('success', 'Request deleted successfully.');
    }
}
