<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function index()
    {
        $hik_central = [
            'url' => env('HIKCENTRAL_API_BASE_URL'),
            'app_key' => env('HIKCENTRAL_APP_KEY'),
            'app_secret' => env('HIKCENTRAL_APP_SECRET'),
        ];
        $database = [
            'host' => env('DB_HOST'),
            'database' => env('DB_DATABASE'),
            'username' => env('DB_USERNAME'),
        ];
        return view('settings', compact('hik_central', 'database'));
    }

    public function hikcentral_configure(Request $request)
    {
        $url = $request->url;
        $app_key = $request->app_key;
        $app_secret = $request->app_secret;

        $path = base_path('.env');
        $test = file_get_contents($path);
        if (file_exists($path)) {
            $newContent = str_replace('HIKCENTRAL_API_BASE_URL=' . env('HIKCENTRAL_API_BASE_URL'),'HIKCENTRAL_API_BASE_URL=' . $url, $test);
            $newContent = str_replace('HIKCENTRAL_APP_KEY=' . env('HIKCENTRAL_APP_KEY'),'HIKCENTRAL_APP_KEY=' . $app_key, $newContent);
            $newContent = str_replace('HIKCENTRAL_APP_SECRET=' . env('HIKCENTRAL_APP_SECRET'), 'HIKCENTRAL_APP_SECRET=' . $app_secret, $newContent);
        
            // Write all changes at once
            file_put_contents($path, $newContent);
        }
        // dd('HIKCENTRAL_API_BASE_URL=' . $url, 'HIKCENTRAL_APP_KEY=' . $app_key,'HIKCENTRAL_APP_SECRET=' . $app_secret);
        return redirect()->route('settings');
    }
}
