<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Attendance extends Model
{
    use HasFactory;

    protected $table = 'attendances';

    protected $fillable = [
        'user_id', 'start', 'end', 'status', 'description', 'location', 'latitude', 'longitude', 'remark', 'supporting_attachment_path',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
