<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Request extends Model
{
    use HasFactory;

    protected $table = 'requests';

    protected $fillable = [
        'user_id', 'request_type_id', 'start', 'end', 
        'location', 'latitude', 'longitude', 'description', 'supporting_attachment_path', 'status',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function request_type()
    {
        return $this->belongsTo(RequestType::class);
    }
}
