<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */

    protected $table = 'users';

    protected $fillable = [
        'email', 'password', 'staff_id', 'first_name', 'last_name', 'profile_picture_path', 'name', 'phone_number',
        'address', 'nric_passport', 'position', 'department_hierarchy',
        'working_time', 'card_status', 'vehicle_number', 'sticker_number',
        'gender', 'user_type', 'online_checkin', 'attendance_check',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];


    public function attendances()
    {
        return $this->hasMany(Attendance::class);
    }

    public function overtimes()
    {
        return $this->hasMany(Overtime::class);
    }

    public function requests()
    {
        return $this->hasMany(Request::class);
    }

    public function leaves()
    {
        return $this->hasMany(Leave::class);
    }

    public function reports()
    {
        return $this->hasMany(Report::class);
    }

    public function announcements()
    {
        return $this->hasMany(Announcement::class, 'created_by');
    }


    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
}
