<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id()->primary();
            
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('staff_id')->unique();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('profile_picture_path')->nullable();
            $table->string('name')->virtualAs('CONCAT(first_name, " ", last_name)');
            $table->string('phone_number')->nullable();
            $table->text('address')->nullable();
            $table->string('nric_passport')->unique()->nullable();
            $table->enum('position', ['Pegawai Tetap', 'Pegawai Sementara', 'Pelatih', 'Other'])->default('Other');
            $table->string('department_hierarchy')->nullable();
            $table->enum('working_time', ['Flexible', 'Waktu Perkerjaan 1', 'Waktu Perkerjaan 2', 'Waktu Perkerjaan 3']);
            $table->enum('card_status', ['Green', 'Yellow', 'Red'])->nullable();
            $table->string('vehicle_number')->nullable();
            $table->string('sticker_number')->nullable();
            $table->enum('gender', ['Male', 'Female']);
            $table->enum('user_type', ['System Admin', 'Security Admin', 'HR Admin', 'Department Admin', 'Staff', 'Auxiliary Police', 'Temporary Staff']);
            $table->boolean('online_checkin')->default(false);
            $table->boolean('attendance_check')->default(true);
            $table->rememberToken();
            $table->timestamps();
        });

        DB::table('users')->insert([
            [
                'email' => 'admin@example.com',
                'password' => bcrypt('password'),
                'staff_id' => 'S001',
                'first_name' => 'John',
                'last_name' => 'Doe',
                'profile_picture_path' => '/system/profile1.jpg',
                'phone_number' => '0123456789',
                'address' => '123, Main Street, City',
                'nric_passport' => '901010-10-1010',
                'position' => 1,
                'department_hierarchy' => 'Admin/HR',
                'working_time' => 'Flexible',
                'card_status' => 'Green',
                'vehicle_number' => 'ABC1234',
                'sticker_number' => 'ST123',
                'gender' => 'Male',
                'user_type' => 'System Admin',
                'online_checkin' => true,
                'attendance_check' => true,
            ],
            [
                'email' => 'staff1@example.com',
                'password' => bcrypt('password'),
                'staff_id' => 'S002',
                'first_name' => 'Jane',
                'last_name' => 'Smith',
                'profile_picture_path' => '/system/profile2.jpeg',
                'phone_number' => '0198765432',
                'address' => '456, Another Street, City',
                'nric_passport' => '920202-02-2020',
                'position' => 1,
                'department_hierarchy' => 'Sales/Team A',
                'working_time' => 'Waktu Perkerjaan 1',
                'card_status' => 'Yellow',
                'vehicle_number' => 'XYZ9876',
                'sticker_number' => 'ST987',
                'gender' => 'Female',
                'user_type' => 'Staff',
                'online_checkin' => false,
                'attendance_check' => true,
            ],
        ]);

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
