<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('attendances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users','id')->onDelete('cascade');
            $table->dateTime('start')->nullable();
            $table->dateTime('end')->nullable();
            $table->enum('status', ['On Time', 'Late Check-In', 'Early Check-Out', 'No Check-Out', 'Absent']);
            $table->text('description')->nullable();
            $table->string('location')->nullable();
            $table->float('latitude')->nullable();
            $table->float('longitude')->nullable();
            $table->text('remark')->nullable();
            $table->string('supporting_attachment_path')->nullable();
            $table->timestamps();
        });

        DB::table('attendances')->insert([
            [
                'user_id' => 1,
                'start' => '2024-08-19 08:00:00',
                'end' => '2024-08-19 17:00:00',
                'status' => 'On Time',
                'description' => 'Working at office',
                'location' => 'Alamesra',
                'latitude' => '6.0319397',
                'longitude' => '116.1334173',
                'remark' => 'test',
                'supporting_attachment_path' => null,
            ],
            [
                'user_id' => 2,
                'start' => '2024-08-19 09:15:00',
                'end' => '2024-08-19 18:00:00',
                'status' => 'Late Check-In',
                'description' => 'Working at office',
                'location' => 'Alamesra',
                'latitude' => '6.0319397',
                'longitude' => '116.1334173',
                'remark' => 'Traffic jam',
                'supporting_attachment_path' => null,
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('attendances');
    }
};
