<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('overtimes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users', 'id')->onDelete('cascade');
            $table->dateTime('start');
            $table->dateTime('end');
            $table->text('description')->nullable();
            $table->string('location')->nullable();
            $table->float('latitude')->nullable();
            $table->float('longitude')->nullable();
            $table->string('supporting_attachment_path')->nullable();
            $table->enum('status', ['Pending', 'Approved', 'Rejected'])->default('Pending');
            $table->timestamps();
        });

        DB::table('overtimes')->insert([
            [
                'user_id' => 1,
                'start' => '2024-08-19 14:30:00',
                'end' => '2024-08-19 20:30:00',
                'description' => 'Project deadline',
                'location' => 'Alamesra',
                'latitude' => '6.0319397',
                'longitude' => '116.1334173',
                'supporting_attachment_path' => null,
                'status' => 'Approved',
            ],
            [
                'user_id' => 2,
                'start' => '2024-08-19 14:30:00',
                'end' => '2024-08-19 23:00:00',
                'description' => 'Urgent client request',
                'location' => 'Alamesra',
                'latitude' => '6.0319397',
                'longitude' => '116.1334173',
                'supporting_attachment_path' => null,
                'status' => 'Pending',
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('overtimes');
    }
};
