<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users', 'id')->onDelete('cascade');
            $table->foreignId('request_type_id')->constrained('request_type', 'id')->onDelete('cascade');
            $table->date('start');
            $table->date('end');
            $table->text('description')->nullable();
            $table->string('location')->nullable();
            $table->float('latitude')->nullable();
            $table->float('longitude')->nullable();
            $table->string('supporting_attachment_path')->nullable();
            $table->enum('status', ['Pending', 'Approved', 'Rejected'])->default('Pending');
            $table->timestamps();
        });

        DB::table('requests')->insert([
            [
                'user_id' => 1,
                'request_type_id' => 1,
                'start' => '2024-08-20',
                'end' => '2024-08-20',
                'description' => 'Family emergency',
                'location' => 'Alamesra',
                'latitude' => '6.0319397',
                'longitude' => '116.1334173',
                'supporting_attachment_path' => null,
                'status' => 'Approved',
            ],
            [
                'user_id' => 2,
                'request_type_id' => 2,
                'start' => '2024-08-25',
                'end' => '2024-08-26',
                'description' => 'Professional development',
                'location' => 'Alamesra',
                'latitude' => '6.0319397',
                'longitude' => '116.1334173',
                'supporting_attachment_path' => null,
                'status' => 'Pending',
            ],
        ]);
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('requests');
    }
};
