<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('leaves', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users','id')->onDelete('cascade');
            $table->foreignId('leave_type_id')->constrained('leave_type','id')->onDelete('cascade');
            $table->date('start');
            $table->date('end');
            $table->text('reason')->nullable();
            $table->string('supporting_attachment_path')->nullable();
            // $table->enum('status', ['Pending', 'Approved', 'Rejected'])->default('Pending');
            $table->timestamps();
        });

        DB::table('leaves')->insert([
            [
                'user_id' => 1,
                'leave_type_id' => 1,
                'start' => '2024-09-01',
                'end' => '2024-09-05',
                'reason' => 'Vacation',
                'supporting_attachment_path' => null,
                // 'status' => 'Approved',
            ],
            [
                'user_id' => 2,
                'leave_type_id' => 2,
                'start' => '2024-09-10',
                'end' => '2024-09-10',
                'reason' => 'Personal emergency',
                'supporting_attachment_path' => null,
                // 'status' => 'Pending',
            ],
        ]);
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('leaves');
    }
};
