<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users','id')->onDelete('cascade');
            $table->enum('report_type', ['Attendance', 'Request', 'Overtime', 'Leave']);
            $table->json('data');
            $table->timestamps();
        });

        DB::table('reports')->insert([
            [
                'user_id' => 1,
                'report_type' => 'Attendance',
                'data' => json_encode([
                    'total_days' => 20,
                    'on_time' => 18,
                    'late' => 2,
                ]),
            ],
            [
                'user_id' => 2,
                'report_type' => 'Overtime',
                'data' => json_encode([
                    'total_hours' => 12,
                    'approved' => 10,
                    'pending' => 2,
                ]),
            ],
        ]);
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reports');
    }
};
