<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('setting_key')->unique();
            $table->string('setting_value')->nullable();
            $table->timestamps();
        });

        DB::table('settings')->insert([
            [
                'setting_key' => 'system_name',
                'setting_value' => 'Attendance Management System',
            ],
            [
                'setting_key' => 'admin_email',
                'setting_value' => 'admin@example.com',
            ],
        ]);
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
