<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('announcements', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('content');
            $table->foreignId('created_by')->constrained('users','id')->onDelete('cascade');
            $table->timestamps();
        });

        DB::table('announcements')->insert([
            [
                'title' => 'System Maintenance',
                'content' => 'The system will be down for maintenance on 2024-08-30 from 10:00 PM to 12:00 AM.',
                'created_by' => 1,
            ],
            [
                'title' => 'Public Holiday Notice',
                'content' => 'Please note that 2024-09-16 is a public holiday for Malaysia Day.',
                'created_by' => 1,
            ],
        ]);
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('announcements');
    }
};
