<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('integrations', function (Blueprint $table) {
            $table->id();
            $table->string('service_name');
            $table->enum('status', ['Active', 'Inactive', 'Error'])->default('Active');
            $table->timestamp('last_sync')->nullable();
            $table->timestamps();
        });

        DB::table('integrations')->insert([
            [
                'service_name' => 'HikCentral',
                'status' => 'Active',
                'last_sync' => '2024-08-18 12:00:00',
            ],
            [
                'service_name' => 'SMTP Relay',
                'status' => 'Error',
                'last_sync' => '2024-08-19 08:00:00',
            ],
        ]);
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('integrations');
    }
};
