<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('archives', function (Blueprint $table) {
            $table->id();
            $table->string('table_name');
            $table->unsignedBigInteger('record_id');
            $table->timestamp('archived_at')->useCurrent();
            $table->timestamps();
        });

        DB::table('archives')->insert([
            [
                'table_name' => 'attendances',
                'record_id' => 1,
                'archived_at' => now(),
            ],
            [
                'table_name' => 'requests',
                'record_id' => 2,
                'archived_at' => now(),
            ],
        ]);
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('archives');
    }
};
