<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('accesstoken', function (Blueprint $table) {
            $table->id('AccessTokenId');
            $table->string('AccessTokenCode', 1000)->default('');
            $table->integer('UserId')->default(0);
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->dateTime('DateTimeExpired')->default('0001-01-01 00:00:00');
            $table->timestamps();
            $table->index(['AccessTokenCode'], 'idx_AccessToken1');
            $table->index('UserId', 'idx_AccessToken2');
        });
    }

    public function down()
    {
        Schema::dropIfExists('accesstoken');
    }
};