<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('announcement', function (Blueprint $table) {
            $table->id('AnnouncementId');
            $table->integer('UserId')->default(0);
            $table->text('Title')->default('');
            $table->text('Message')->default('');
            $table->text('AttachmentName')->default('');
            $table->integer('ValidDays')->default(0);
            $table->integer('DayYearExpiry')->default(0);
            $table->integer('UserIdCreated')->default(0);
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->boolean('Deleted')->default(0);
            $table->timestamps();
            $table->index('UserId', 'idx_Announcement1');
        });
    }

    public function down()
    {
        Schema::dropIfExists('announcement');
    }
};
