<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('approver', function (Blueprint $table) {
            $table->id('ApproverId');
            $table->integer('RequesterUserId')->default(0);
            $table->integer('ApproverUserId')->default(0);
            $table->boolean('IsViewOnly')->default(0);
            $table->integer('UserIdCreated')->default(0);
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->boolean('Deleted')->default(0);
            $table->integer('UserIdDeleted')->default(0);
            $table->dateTime('DateTimeDeleted')->default('0001-01-01 00:00:00');
            $table->timestamps();
            $table->index(['RequesterUserId', 'Deleted'], 'idx_Approver1');
            $table->index(['ApproverUserId', 'Deleted'], 'idx_Approver2');
            $table->index(['RequesterUserId', 'ApproverUserId', 'Deleted'], 'idx_Approver3');
        });
    }

    public function down()
    {
        Schema::dropIfExists('approver');
    }
};

