<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('attachment', function (Blueprint $table) {
            $table->id('AttachmentId');
            $table->string('AttachmentName', 255)->default('');
            $table->integer('RequestId')->default(0);
            $table->integer('UserId')->default(0);
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->boolean('Deleted')->default(0);
            $table->dateTime('DateTimeDeleted')->default('0001-01-01 00:00:00');
            $table->timestamps();
            $table->index(['RequestId', 'Deleted'], 'idx_Attachment1');
        });
    }

    public function down()
    {
        Schema::dropIfExists('attachment');
    }
};
