<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('attendance', function (Blueprint $table) {
            $table->id('AttendanceId');
            $table->integer('UserId')->default(0);
            $table->integer('Year')->default(0);
            $table->integer('MonthYear')->default(0);
            $table->integer('DayYear')->default(0);
            $table->dateTime('DateTimeStart')->default('0001-01-01 00:00:00');
            $table->dateTime('DateTimeEnd')->default('0001-01-01 00:00:00');
            $table->string('Description', 1000)->default('');
            $table->string('CheckInLocation', 255)->default('');
            $table->string('CheckOutLocation', 255)->default('');
            $table->string('Remark', 1000)->default('');
            $table->string('Reason', 1000)->default('');
            $table->boolean('IsManualCheckOut')->default(0);
            $table->boolean('IsDevice')->default(0);
            $table->integer('WorkingTypeId')->default(0);
            $table->integer('WorkingShiftId')->default(0);
            $table->dateTime('DateTimeStartRequired')->default('0001-01-01 00:00:00');
            $table->dateTime('DateTimeEndRequired')->default('0001-01-01 00:00:00');
            $table->integer('MinutesRequired')->default(0);
            $table->integer('AllowLateMinutes')->default(0);
            $table->decimal('CheckInLatitude', 24, 16)->default(0.0000000000000000);
            $table->decimal('CheckInLongitude', 24, 16)->default(0.0000000000000000);
            $table->decimal('CheckOutLatitude', 24, 16)->default(0.0000000000000000);
            $table->decimal('CheckOutLongitude', 24, 16)->default(0.0000000000000000);
            $table->string('BrowserType', 255)->default('');
            $table->string('BrowserPlatform', 255)->default('');
            $table->boolean('IsLateCheckIn')->default(0);
            $table->boolean('IsEarlyCheckOut')->default(0);
            $table->boolean('IsNoCheckOut')->default(0);
            $table->integer('UserIdCreated')->default(0);
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->integer('UserIdUpdated')->default(0);
            $table->dateTime('DateTimeUpdated')->default('0001-01-01 00:00:00');
            $table->boolean('Deleted')->default(0);
            $table->integer('UserIdDeleted')->default(0);
            $table->dateTime('DateTimeDeleted')->default('0001-01-01 00:00:00');
            $table->integer('StatusId')->default(0);
            $table->integer('UserIdStatus')->default(0);
            $table->dateTime('DateTimeStatus')->default('0001-01-01 00:00:00');
            $table->timestamps();
            $table->index('Deleted', 'idx_Attendance1');
            $table->index(['UserId', 'Deleted'], 'idx_Attendance2');
            $table->index(['UserId', 'DayYear', 'Deleted'], 'idx_Attendance3');
        });
    }

    public function down()
    {
        Schema::dropIfExists('attendance');
    }
};
