<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('deviceaccess', function (Blueprint $table) {
            $table->id('AccessId');
            $table->integer('UserId')->default(0);
            $table->integer('VisitorId')->default(0);
            $table->string('PersonId', 255)->charset('utf8mb4')->collation('utf8mb4_bin')->default('');
            $table->string('EventId', 255)->charset('utf8mb4')->collation('utf8mb4_bin')->default('');
            $table->integer('DayYearEvent')->default(0);
            $table->dateTime('DateTimeEvent')->default('0001-01-01 00:00:00');
            $table->string('DoorId', 255)->default('');
            $table->string('DoorName', 1000)->default('');
            $table->decimal('Temperature', 24, 20)->default(0.00000000000000000000);
            $table->integer('Accuracy')->default(0);
            $table->string('ImageURL', 255)->default('');
            $table->boolean('IsChecked')->default(0);
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->boolean('Deleted')->default(0);
            $table->integer('UserIdDeleted')->default(0);
            $table->dateTime('DateTimeDeleted')->default('0001-01-01 00:00:00');
            $table->timestamps();

            $table->index(['IsChecked', 'Deleted'], 'idx_DeviceAccess1');
            $table->index(['PersonId', 'Deleted'], 'idx_DeviceAccess2');
            $table->index(['PersonId', 'DateTimeEvent', 'Deleted'], 'idx_DeviceAccess3');
            $table->index(['EventId', 'Deleted'], 'idx_DeviceAccess4');
        });
    }

    public function down()
    {
        Schema::dropIfExists('deviceaccess');
    }
};
