<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('division', function (Blueprint $table) {
            $table->id('DivisionId');
            $table->string('OrgIndexCode', 1000)->default('');
            $table->string('DivisionName', 255)->default('');
            $table->string('Description', 1000)->default('');
            $table->integer('CenterId')->default(0);
            $table->integer('UserIdCreated')->default(0);
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->integer('UserIdUpdated')->default(0);
            $table->dateTime('DateTimeUpdated')->default('0001-01-01 00:00:00');
            $table->boolean('Deleted')->default(0);
            $table->integer('UserIdDeleted')->default(0);
            $table->dateTime('DateTimeDeleted')->default('0001-01-01 00:00:00');
            $table->timestamps();
            $table->index('Deleted', 'idx_Division1');
            $table->index(['CenterId', 'Deleted'], 'idx_Division2');
        });
    }

    public function down()
    {
        Schema::dropIfExists('division');
    }
};
