<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('evententitlement', function (Blueprint $table) {
            $table->id('EntitleId');
            $table->integer('EventId')->default(0);
            $table->integer('UserId')->default(0);
            $table->integer('UserIdCreated')->default(0);
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->integer('UserIdUpdated')->default(0);
            $table->dateTime('DateTimeUpdated')->default('0001-01-01 00:00:00');
            $table->boolean('Deleted')->default(0);
            $table->integer('UserIdDeleted')->default(0);
            $table->dateTime('DateTimeDeleted')->default('0001-01-01 00:00:00');
            $table->timestamps();
            $table->index(['UserId', 'Deleted'], 'idx_EventEntitlement1');
        });
    }

    public function down()
    {
        Schema::dropIfExists('evententitlement');
    }
};
