<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('holiday', function (Blueprint $table) {
            $table->id('HolidayId');
            $table->string('Description', 1000)->default('');
            $table->integer('Year')->default(0);
            $table->integer('MonthYear')->default(0);
            $table->integer('DayYear')->default(0);
            $table->integer('UserIdCreated')->default(0);
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->integer('UserIdUpdated')->default(0);
            $table->dateTime('DateTimeUpdated')->default('0001-01-01 00:00:00');
            $table->boolean('Deleted')->default(0);
            $table->integer('UserIdDeleted')->default(0);
            $table->dateTime('DateTimeDeleted')->default('0001-01-01 00:00:00');
            $table->timestamps();
            $table->index(['Year', 'Deleted'], 'idx_Holiday1');
            $table->index(['DayYear', 'Deleted'], 'idx_Holiday2');
        });
    }

    public function down()
    {
        Schema::dropIfExists('holiday');
    }
};
