<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('processemail', function (Blueprint $table) {
            $table->id('EmailId');
            $table->string('SenderName', 255)->default('');
            $table->string('SenderAddress', 255)->default('');
            $table->string('RecipientNames', 255)->default('');
            $table->string('RecipientAddresses', 255)->default('');
            $table->string('Subject', 255)->default('');
            $table->text('Body')->default('');
            $table->string('AttachmentName', 255)->default('');
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->integer('ErrorCount')->default(0);
            $table->boolean('IsSent')->default(0);
            $table->dateTime('DateTimeSent')->default('0001-01-01 00:00:00');
            $table->boolean('Deleted')->default(0);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('processemail');
    }
};
