<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('service', function (Blueprint $table) {
            $table->id('ServiceId');
            $table->string('LastEventId', 255)->default('');
            $table->integer('TotalRecord')->default(0);
            $table->dateTime('DateTimeStarted')->default('0001-01-01 00:00:00');
            $table->dateTime('DateTimeEnded')->default('0001-01-01 00:00:00');
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->timestamps();
            $table->index('LastEventId', 'idx_Service1');
        });
    }

    public function down()
    {
        Schema::dropIfExists('service');
    }
};
