<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('systemsetting', function (Blueprint $table) {
            $table->id('SettingId');
            $table->string('ShortName', 255)->default('');
            $table->string('CompanyName', 255)->default('');
            $table->string('SystemName', 255)->default('');
            $table->string('SystemNameBM', 255)->default('');
            $table->string('SMTPServer', 255)->default('');
            $table->string('SMTPUsername', 255)->default('');
            $table->string('SMTPPassword', 255)->default('');
            $table->integer('SMTPPort')->default(0);
            $table->boolean('SMTPSSL')->default(0);
            $table->string('SMTPSenderName', 255)->default('');
            $table->dateTime('TerminalLastSynced')->default('0001-01-01 00:00:00');
            $table->dateTime('RegistrationLastSynced')->default('0001-01-01 00:00:00');
            $table->dateTime('LastServiceProcess')->default('0001-01-01 00:00:00');
            $table->integer('DailyCheckPoint')->default(0);
            $table->boolean('SendEmail')->default(0);
            $table->boolean('AllowOnlineCheckIn')->default(0);
            $table->integer('CheckInStartTime')->default(0);
            $table->integer('CheckInEndTime')->default(0);
            $table->boolean('IsStartTimeFixed')->default(0);
            $table->integer('BeforeStartTimeMinutes')->default(0);
            $table->integer('TotalWorkingMinutes')->default(0);
            $table->integer('TotalDayBackdate')->default(0);
            $table->integer('AllowLateMinutes')->default(0);
            $table->integer('PregnancyAllowanceMinutes')->default(0);
            $table->integer('AutoCheckOut')->default(0);
            $table->boolean('ReasonApprovalEmail')->default(0);
            $table->boolean('RequestApprovalEmail')->default(0);
            $table->boolean('AttendanceWarningEmail')->default(0);
            $table->boolean('ReasonRequireEmail')->default(0);
            $table->integer('ReminderTime')->default(0);
            $table->integer('ReminderCheckPoint')->default(0);
            $table->boolean('TerminalFeature')->default(0);
            $table->boolean('RegistrationFeature')->default(0);
            $table->string('ServerName', 255)->default('');
            $table->string('ApplicationKey', 255)->default('');
            $table->string('ApplicationSecret', 255)->default('');
            $table->string('EventType', 255)->default('');
            $table->string('StaffOrganizationId', 255)->default('');
            $table->string('VisitorOrganizationId', 255)->default('');
            $table->string('GoogleKey', 255)->default('');
            $table->boolean('AllowPersonalReport')->default(0);
            $table->integer('FixedStartTime')->default(0);
            $table->integer('FixedEndTime')->default(0);
            $table->integer('StartTimeShift1')->default(0);
            $table->integer('StartTimeShift2')->default(0);
            $table->integer('StartTimeShift3')->default(0);
            $table->boolean('ApprovalRequireEmail')->default(0);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('systemsetting');
    }
};
