<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('useractivity', function (Blueprint $table) {
            $table->id('ActivityId');
            $table->integer('UserId')->default(0);
            $table->dateTime('DateTime')->default('0001-01-01 00:00:00');
            $table->integer('DayYear')->default(0);
            $table->integer('EventType')->default(0);
            $table->string('Location', 255)->default('');
            $table->string('Note', 1000)->default('');
            $table->boolean('Deleted')->default(0);
            $table->timestamps();
            $table->index(['UserId', 'DayYear', 'Deleted'], 'idx_UserActivity1');
        });
    }

    public function down()
    {
        Schema::dropIfExists('useractivity');
    }
};
