<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('userprofile', function (Blueprint $table) {
            $table->id('UserId');
            $table->string('StaffId', 255)->default('');
            $table->string('UserEmail', 255)->default('');
            $table->text('UserPassword')->default('');
            $table->integer('UserTypeId')->default(0);
            $table->string('FullName', 255)->default('');
            $table->string('FirstName', 255)->default('');
            $table->string('LastName', 255)->default('');
            $table->string('PhoneNumber', 255)->default('');
            $table->integer('Gender')->default(0);
            $table->string('Address', 255)->default('');
            $table->string('NRIC', 255)->default('');
            $table->string('Designation', 255)->default('');
            $table->integer('PositionId')->default(0);
            $table->integer('OfficeId')->default(0);
            $table->integer('DivisionId')->default(0);
            $table->integer('SectionId')->default(0);
            $table->integer('UnitId')->default(0);
            $table->integer('SupervisorId')->default(0);
            $table->integer('WorkingTypeId')->default(0);
            $table->text('HashCode')->default('');
            $table->string('ResetCode', 255)->default('');
            $table->text('RegisterCode')->default('');
            $table->string('EmergencyContactName', 255)->default('');
            $table->string('EmergencyContactNumber', 255)->default('');
            $table->string('Remark', 255)->default('');
            $table->text('UserImage')->default('');
            $table->boolean('FirstTime')->default(1);
            $table->boolean('Blocked')->default(0);
            $table->boolean('SuperAccount')->default(0);
            $table->boolean('NeedCreate')->default(0);
            $table->boolean('NeedUpdate')->default(0);
            $table->boolean('NeedDelete')->default(0);
            $table->boolean('NeedResyncImage')->default(0);
            $table->boolean('NeedSyncImage')->default(0);
            $table->boolean('ImageError')->default(0);
            $table->string('PersonId', 255)->default(NULL);
            $table->string('OrgIndexCode', 255)->default('');
            $table->integer('LanguageOption')->default(1);
            $table->boolean('StopEmail')->default(0);
            $table->boolean('IsPregnancy')->default(0);
            $table->integer('DayYearDue')->default(1);
            $table->dateTime('DateTimeNowLogin')->default('0001-01-01 00:00:00');
            $table->dateTime('DateTimeLastLogin')->default('0001-01-01 00:00:00');
            $table->dateTime('DateTimeReset')->default('0001-01-01 00:00:00');
            $table->dateTime('DateTimeLastRead')->default('0001-01-01 00:00:00');
            $table->integer('UserIdCreated')->default(0);
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->integer('UserIdUpdated')->default(0);
            $table->dateTime('DateTimeUpdated')->default('0001-01-01 00:00:00');
            $table->boolean('Deleted')->default(0);
            $table->integer('UserIdDeleted')->default(0);
            $table->dateTime('DateTimeDeleted')->default('0001-01-01 00:00:00');
            $table->integer('HQStateId')->default(0);
            $table->integer('CenterId')->default(0);
            $table->timestamps();
            $table->index(['UserEmail', 'Deleted'], 'idx_UserProfile1');
            $table->index(['ResetCode', 'Deleted'], 'idx_UserProfile2');
            $table->index('Deleted', 'idx_UserProfile3');
            $table->index(['StaffId', 'Deleted'], 'idx_UserProfile4');
            $table->index(['PersonId', 'Deleted'], 'idx_UserProfile5');
        });
    }

    public function down()
    {
        Schema::dropIfExists('userprofile');
    }
};
