<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('visitor', function (Blueprint $table) {
            $table->id('VisitorId');
            $table->string('Email', 255)->default('');
            $table->string('FullName', 255)->default('');
            $table->string('FirstName', 255)->default('');
            $table->string('LastName', 255)->default('');
            $table->string('PhoneNumber', 255)->default('');
            $table->integer('Gender')->default(0);
            $table->string('Address', 255)->default('');
            $table->string('NRIC', 255)->default('');
            $table->string('Designation', 255)->default('');
            $table->string('CompanyName', 255)->default('');
            $table->string('CompanyAddress', 255)->default('');
            $table->string('OfficerName', 255)->default('');
            $table->text('HashCode')->default('');
            $table->string('Remark', 255)->default('');
            $table->mediumText('VisitorImage')->default('');
            $table->boolean('NeedCreate')->default(0);
            $table->boolean('NeedUpdate')->default(0);
            $table->boolean('NeedDelete')->default(0);
            $table->boolean('NeedResyncImage')->default(0);
            $table->boolean('NeedSyncImage')->default(0);
            $table->boolean('ImageError')->default(0);
            $table->string('PersonId', 255)->default(NULL);
            $table->integer('UserIdCreated')->default(0);
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->integer('UserIdUpdated')->default(0);
            $table->dateTime('DateTimeUpdated')->default('0001-01-01 00:00:00');
            $table->boolean('Deleted')->default(0);
            $table->integer('UserIdDeleted')->default(0);
            $table->dateTime('DateTimeDeleted')->default('0001-01-01 00:00:00');
            $table->timestamps();
            $table->index('Deleted', 'idx_Visitor1');
            $table->index(['PersonId', 'Deleted'], 'idx_Visitor2');
        });
    }

    public function down()
    {
        Schema::dropIfExists('visitor');
    }
};
