<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('visitorregistration', function (Blueprint $table) {
            $table->id('RegistrationId');
            $table->integer('VisitorId')->default(0);
            $table->integer('PurposeId')->default(0);
            $table->integer('CounterId')->default(0);
            $table->integer('OfficerId')->default(0);
            $table->dateTime('DateTimeStart')->default('0001-01-01 00:00:00');
            $table->dateTime('DateTimeEnd')->default('0001-01-01 00:00:00');
            $table->string('Remark', 1000)->default('');
            $table->integer('UserIdCreated')->default(0);
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->integer('DayYearCreated')->default(0);
            $table->integer('MonthYearCreated')->default(0);
            $table->integer('UserIdUpdated')->default(0);
            $table->dateTime('DateTimeUpdated')->default('0001-01-01 00:00:00');
            $table->boolean('Deleted')->default(0);
            $table->integer('UserIdDeleted')->default(0);
            $table->dateTime('DateTimeDeleted')->default('0001-01-01 00:00:00');
            $table->integer('YearCreated')->default(0);
            $table->string('VisitorPass', 1000)->default('');
            $table->timestamps();
            $table->index('Deleted', 'idx_VisitorRegistration1');
            $table->index(['VisitorId', 'Deleted'], 'idx_VisitorRegistration2');
            $table->index(['DayYearCreated', 'Deleted'], 'idx_VisitorRegistration3');
        });
    }

    public function down()
    {
        Schema::dropIfExists('visitorregistration');
    }
};
