<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('workrequest', function (Blueprint $table) {
            $table->id('RequestId');
            $table->integer('UserId')->default(0);
            $table->integer('Year')->default(0);
            $table->integer('MonthYear')->default(0);
            $table->integer('DayYearStart')->default(0);
            $table->integer('DayYearEnd')->default(0);
            $table->integer('RequestTypeId')->default(0);
            $table->string('Description', 1000)->default('');
            $table->string('Location', 255)->default('');
            $table->string('Reason', 1000)->default('');
            $table->string('Remark', 1000)->default('');
            $table->integer('StatusId')->default(0);
            $table->integer('UserIdStatus')->default(0);
            $table->integer('UserIdCreated')->default(0);
            $table->dateTime('DateTimeStatus')->default('0001-01-01 00:00:00');
            $table->dateTime('DateTimeCreated')->default('0001-01-01 00:00:00');
            $table->integer('UserIdUpdated')->default(0);
            $table->dateTime('DateTimeUpdated')->default('0001-01-01 00:00:00');
            $table->boolean('Deleted')->default(0);
            $table->integer('UserIdDeleted')->default(0);
            $table->dateTime('DateTimeDeleted')->default('0001-01-01 00:00:00');
            $table->timestamps();
            $table->index('RequestId', 'idx_WorkRequest');
            $table->index('Deleted', 'idx_WorkRequest1');
            $table->index(['UserId', 'Deleted'], 'idx_WorkRequest2');
            $table->index(['UserId', 'DayYearStart', 'DayYearEnd', 'Deleted'], 'idx_WorkRequest3');
        });
    }

    public function down()
    {
        Schema::dropIfExists('workrequest');
    }
};
