@extends('layouts.app')

@push('script')
    <style>
        .resizer {
            /* background-color: #ddd; */
            cursor: ns-resize;
            height: 10px;
            width: 100%;
            display: flex;
            align-items: center;
        }
        .resizer-line{
            height: 2px;
            width: 100%;
            background-color: #aaa;
        }
        .container-top {
            height: 50%;
        
        }
        .container-bottom {
            height: 50%;
        }
    </style>
@endpush

@section('hcp-button-class', 'active')

@section('tab-name', 'HikCentral Professional')

@section('header-left')
    <div onclick="tab_click(this, 'personal')" class="header-tab-button theme-primary-a2 active fs-12 fw-bold pd-10 mg-r-5 br-5 clr-grey-2 cursor-pointer">Access Control</div>
    <div onclick="tab_click(this, 'system')" class="header-tab-button theme-primary-a2 fs-12 fw-bold pd-10 br-5 clr-grey-2 cursor-pointer">Manage User</div>
@endsection

@section('main-body')
    <div class="tab active h-100p w-100p">
        <div class="container-top d-flex of-auto">
            <!-- <a class="mg-t-30 mg-l-30 w-80 h-150 cursor-pointer theme-primary-hv3 br-5">
                <div class="w-100p h-100 d-flex-center">
                    <span class="material-symbols-outlined" style="font-size: 70px;">meeting_room</span>
                </div>
                <div class="w-70 h-40 d-flex jc-center fs-12 fw-bold clr-grey-2 mg-5" style="word-break: break-word;">Haida</div>
            </a> -->
            <!-- <input type="file" id="fileInput" accept="image/*"> -->
        </div>
        <div class="resizer">
            <div class="resizer-line"></div>
        </div>
        <div class="container-bottom of-auto">
        <div class="of-auto" style="overflow:auto">
            <table id="user-table" class="table-1">
                <thead>
                    <tr>
                        <th></th>
                        <th>Name</th>
                        <th>Position</th>
                        <th>Door</th>
                        <th>Event Type</th>
                        <th>Date</th>
                        <th>Time</th>
                    </tr>
                </thead>
                <tbody id="user-table-body">
                    <!-- <tr>
                        <td>
                            <div class="d-flex-center">
                                <div class="theme-primary-2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4">1</div>
                            </div>
                        </td>
                        <td>
                            <div class="d-flex tw-nowrap">
                                <div class="d-flex-center">
                                    <div class="d-flex-center br-50p bg-plt1 w-40 h-40"></div>
                                </div>
                                <div class="mg-l-15 mg-t-10 fs-12 fw-bold">
                                    FIRST NAME LAST NMAE
                                </div>
                            </div>
                        </td>
                        <td>
                            <div class="fs-12 clr-grey-1 tw-nowrap">
                                Position
                            </div>
                        </td>
                        <td>
                            <div class="fs-12 clr-grey-1 tw-nowrap">
                                Door name
                            </div>
                        </td>
                        <td>
                            <div class="fs-12 clr-grey-1 tw-nowrap">Event type</div>
                        </td>
                        <td>
                            <div class="fs-12 fw-bold tw-nowrap">
                                Time phase
                            </div>
                        </td>
                    </tr> -->
                </tbody>
            </table>
        </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        const controller = new AbortController();
        const signal = controller.signal;

        let interval1_id;

        function fetch_data(api='', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({})) {
            return fetch(api,{
                    method: method,
                    headers: headers,
                    body: body,
                    signal: signal,
                })
                .then(response => response.json())
                .catch(error => console.error('Error:', error));
        }

        function abort(){
            controller.abort();
            clearInterval(interval1_id)
        }

        // window.addEventListener('beforeunload', stop_fetching);

        document.addEventListener('DOMContentLoaded', function () {
            const resizable = function (resizer) {
                const direction = resizer.getAttribute('data-direction') || 'horizontal';
                const prevSibling = resizer.previousElementSibling;
                const nextSibling = resizer.nextElementSibling;
        
                // The current position of mouse
                let x = 0;
                let y = 0;
                let prevSiblingHeight = 0;
                let prevSiblingWidth = 0;
        
                // Handle the mousedown event
                // that's triggered when user drags the resizer
                const mouseDownHandler = function (e) {
                    // Get the current mouse position
                    x = e.clientX;
                    y = e.clientY;
                    const rect = prevSibling.getBoundingClientRect();
                    prevSiblingHeight = rect.height;
                    prevSiblingWidth = rect.width;
        
                    // Attach the listeners to document
                    document.addEventListener('mousemove', mouseMoveHandler);
                    document.addEventListener('mouseup', mouseUpHandler);
                };
        
                const mouseMoveHandler = function (e) {
                    // How far the mouse has been moved
                    const dx = e.clientX - x;
                    const dy = e.clientY - y;
        
                    const h =
                        ((prevSiblingHeight + dy) * 100) /
                        resizer.parentNode.getBoundingClientRect().height;
                    prevSibling.style.height = h + '%';
        
                    const cursor = direction === 'horizontal' ? 'col-resize' : 'row-resize';
                    resizer.style.cursor = cursor;
                    document.body.style.cursor = cursor;
        
                    prevSibling.style.userSelect = 'none';
                    prevSibling.style.pointerEvents = 'none';
        
                    nextSibling.style.userSelect = 'none';
                    nextSibling.style.pointerEvents = 'none';
                };
        
                const mouseUpHandler = function () {
                    resizer.style.removeProperty('cursor');
                    document.body.style.removeProperty('cursor');
        
                    prevSibling.style.removeProperty('user-select');
                    prevSibling.style.removeProperty('pointer-events');
        
                    nextSibling.style.removeProperty('user-select');
                    nextSibling.style.removeProperty('pointer-events');
        
                    // Remove the handlers of mousemove and mouseup
                    document.removeEventListener('mousemove', mouseMoveHandler);
                    document.removeEventListener('mouseup', mouseUpHandler);
                };
        
                // Attach the handler
                resizer.addEventListener('mousedown', mouseDownHandler);
            };
        
            // Query all resizers
            document.querySelectorAll('.resizer').forEach(function (ele) {
                resizable(ele);
            });

            function getImageBase64(imageUrl, callback) {
                const image = new Image();
                image.crossOrigin = 'Anonymous'; // Handle CORS if needed
                image.src = imageUrl;
                image.onload = () => {
                    const canvas = document.createElement('canvas');
                    const context = canvas.getContext('2d');
                    canvas.width = image.width;
                    canvas.height = image.height;
                    context.drawImage(image, 0, 0);
                    const base64Image = canvas.toDataURL('image/png');
                    callback(base64Image);
                };
                image.onerror = (err) => {
                    console.error('Failed to load image:', err);
                    callback(null, err);
                };
            }

            // document.getElementById('fileInput').addEventListener('change', handleFileSelect);
            function handleFileSelect(event) {
                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const imageDataUrl = e.target.result;
                        const base64Data = imageDataUrl.split(',')[1];

                        Promise.all([fetch_data(api='/artemis/api/acs/v1/faceCheck', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({'faceData':base64Data})),])
                        .then(([data_door]) => {
                            console.log(data_door);
                        })
                        .catch(error => console.error('Error combining data:', error));
                    };
                    reader.onerror = function(err) {
                        console.error('Error reading file:', err);
                    };
                    reader.readAsDataURL(file);
                }
            }

            function face_check() {
                Promise.all([fetch_data(api='/artemis/api/acs/v1/faceCheck', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({'faceData':''})),])
                .then(([data_door]) => {
                    console.log(data_door);
                })
                .catch(error => console.error('Error combining data:', error));
            }
            // face_check()


            function get_access_door() {
                Promise.all([fetch_data(api='/artemis/api/resource/v1/acsDoor/acsDoorList', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({})),])
                .then(([data_door]) => {
                    data_door.data.list.forEach(event => {
                        const button = document.createElement('a');
                        button.className = 'mg-t-30 mg-l-30 w-80 h-150 cursor-pointer theme-primary-hv3 br-5';

                        const button_div1 = document.createElement('div');
                        button_div1.className = 'w-100p h-100 d-flex-center';

                        const button_div1_span1 = document.createElement('span');
                        button_div1_span1.className = 'material-symbols-outlined';
                        button_div1_span1.style.fontSize = '70px';
                        button_div1_span1.textContent = 'meeting_room';

                        button_div1.appendChild(button_div1_span1);

                        const button_div2 = document.createElement('div');
                        button_div2.className = 'w-70 h-40 d-flex jc-center fs-12 fw-bold clr-grey-2 mg-5';
                        button_div2.style.wordBreak = 'break-word';
                        button_div2.textContent = event.doorName;

                        button.appendChild(button_div1);
                        button.appendChild(button_div2);

                        document.querySelector('.container-top').appendChild(button);
                    });
                })
                .catch(error => console.error('Error combining data:', error));
            }
            get_access_door()

            function get_door_event() {
                Promise.all([fetch_data(api='/artemis/api/acs/v1/door/events', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({'startTime':'2024-08-01T15:00:00+08:00','endTime':'2024-08-30T15:00:00+08:00','eventType': 196893, 'personName': '', 'doorIndexCodes': ['3']})), 
                            fetch_data(api='/artemis/api/acs/v1/door/events', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({'startTime':'2024-08-01T15:00:00+08:00','endTime':'2024-08-30T15:00:00+08:00','eventType': 198914, 'personName': '', 'doorIndexCodes': ['3']})), 
                            fetch_data(api='/artemis/api/acs/v1/door/events', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({'startTime':'2024-08-01T15:00:00+08:00','endTime':'2024-08-30T15:00:00+08:00','eventType': 197127, 'personName': '', 'doorIndexCodes': ['3']}))])
                .then(([data_face, data_card, data_fingerprint]) => {
                    const all_data = [...data_face.data.list, ...data_card.data.list, ...data_fingerprint.data.list];

                    all_data.sort((a, b) => new Date(b.eventTime) - new Date(a.eventTime));

                    document.getElementById('user-table-body').innerHTML = '';
                    numbering = 1;
                    all_data.forEach(event => {
                        const row = document.createElement('tr');

                        const td1 = document.createElement('td');

                        const td1_div1 = document.createElement('div');
                        td1_div1.className = 'd-flex-center';

                        const td1_div1_div1 = document.createElement('div');
                        td1_div1_div1.className = 'theme-primary-2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4';
                        td1_div1_div1.textContent = numbering;
                        numbering += 1;

                        td1_div1.appendChild(td1_div1_div1);
                        td1.appendChild(td1_div1);

                        const td2 = document.createElement('td');

                        const td2_div1 = document.createElement('div');
                        td2_div1.className = 'd-flex tw-nowrap';

                        const td2_div1_div1 = document.createElement('div');
                        td2_div1_div1.className = 'd-flex-center';
                        
                        const td2_div1_div1_div1 = document.createElement('div');
                        td2_div1_div1_div1.className = 'd-flex-center br-50p bg-plt1 w-40 h-40';

                        td2_div1_div1.appendChild(td2_div1_div1_div1);

                        const td2_div1_div2 = document.createElement('div');
                        td2_div1_div2.className = 'mg-l-15 mg-t-10 fs-12 fw-bold';
                        td2_div1_div2.textContent = event.personName;

                        td2_div1.appendChild(td2_div1_div1);
                        td2_div1.appendChild(td2_div1_div2);
                        td2.appendChild(td2_div1);

                        const td3 = document.createElement('td');

                        const td3_div1 = document.createElement('div');
                        td3_div1.className = 'fs-12 clr-grey-1 tw-nowrap';
                        td3_div1.textContent = '-'

                        td3.appendChild(td3_div1);

                        const td4 = document.createElement('td');
                        
                        const td4_div1 = document.createElement('div');
                        td4_div1.className = 'fs-12 clr-grey-1 tw-nowrap';
                        td4_div1.textContent = event.doorName;

                        td4.appendChild(td4_div1);

                        const td5 = document.createElement('td');

                        const td5_div1 = document.createElement('div');
                        td5_div1.className = 'fs-12 clr-grey-1 tw-nowrap';
                        if (event.eventType == '196893') {td5_div1.textContent = 'Face'}
                        else if (event.eventType == '197127') {td5_div1.textContent = 'Fingerprint'}
                        else if (event.eventType == '198914') {td5_div1.textContent = 'Card'}
                        
                        td5.appendChild(td5_div1);

                        const td6 = document.createElement('td');

                        const td6_div1 = document.createElement('div');
                        td6_div1.className = 'fs-12 clr-grey-1 tw-nowrap';

                        const date = new Date(event.eventTime);
                        const dateOptions  = {
                            weekday: 'long', 
                            day: 'numeric',
                            month: 'long',
                            year: 'numeric'
                        };
                        const formattedDate = date.toLocaleDateString('en-US', dateOptions);
                        
                        const date_copy = new Date(event.eventTime);
                        date_copy.setHours(0, 0, 0, 0);

                        const today = new Date();
                        today.setHours(0, 0, 0, 0);

                        const yesterday = new Date(today);
                        yesterday.setDate(today.getDate() - 1);

                        if (date_copy.getTime() === today.getTime()) {
                            td6_div1.textContent = 'Today';
                        } else if(date_copy.getTime() === yesterday.getTime()){
                            td6_div1.textContent = 'Yesterday';
                        } else {
                            td6_div1.textContent = formattedDate;
                        }

                        td6.appendChild(td6_div1);

                        const td7 = document.createElement('td');

                        const td7_div1 = document.createElement('div');
                        td7_div1.className = 'fw-bold fs-12 clr-black-1 tw-nowrap';

                        const options = {
                            hour: 'numeric',
                            minute: 'numeric',
                            hour12: true
                        };
                        const formattedTime = date.toLocaleTimeString('en-US', options);

                        td7_div1.textContent = formattedTime;

                        td7.appendChild(td7_div1);

                        row.appendChild(td1);
                        row.appendChild(td2);
                        row.appendChild(td3);
                        row.appendChild(td4);
                        row.appendChild(td5);
                        row.appendChild(td6);
                        row.appendChild(td7);

                        document.getElementById('user-table-body').appendChild(row);
                    });
                })
                .catch(error => console.error('Error combining data:', error));
            }
            
            get_door_event()
            // interval1_id = setInterval(get_door_event, 1000);
        });
    </script>
@endpush