
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- <meta http-equiv="refresh" content="1"> -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <title>Dashboard</title>
    <link href='https://fonts.googleapis.com/css?family=Jura' rel='stylesheet'>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/brands.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/fontawesome.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/regular.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/solid.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/svg-with-js.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/v4-font-face.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/v4-shims.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/v5-font-face.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,200,0,-25" />
    <link href='https://fonts.googleapis.com/css?family=Roboto' rel='stylesheet'>
    <!-- <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,1,0" /> -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <!-- <script src="/js/font/Jura.js"></script>
    <script src="/js/font/Roboto.js"></script>
    <script src="/js/font/library.js"></script> -->

    <link rel="stylesheet" href="/css/layout.css">
    <link rel="stylesheet" href="/css/helper.css">
    <!-- /storage/app/public/system/profile1.jpg -->
    @stack('styles')
    <style>
        
    </style>

</head>
<body>
    <div class="leftbar h-100p w-220 bg-primary" style="position:fixed;">
        <div class="w-100p mg-b-20" style="height:60px"></div>
        <div class="w-100p h-80p" style="height:calc(100% - 120px)">
            <a href="{{route('dashboard')}}" onclick="abort()" class="leftbar-nav-button theme-primary-a1 br-10 d-flex ai-center fs-12 fw-bold clr-grey-2 cursor-pointer @yield('dashboard-button-class')">
                <span class="material-symbols-outlined mg-r-10">dashboard</span>
                Dashboard
            </a>
            <a href="{{route('approval')}}" onclick="abort()" class="leftbar-nav-button theme-primary-a1 br-10 d-flex ai-center fs-12 fw-bold clr-grey-2 cursor-pointer @yield('approval-button-class')">
                <span class="material-symbols-outlined mg-r-10">beenhere</span>
                Approval
            </a>
            <a href="{{route('attendance')}}" onclick="abort()" class="leftbar-nav-button theme-primary-a1 br-10 d-flex ai-center fs-12 fw-bold clr-grey-2 cursor-pointer @yield('attendance-button-class')">
                <span class="material-symbols-outlined mg-r-10">calendar_clock</span>
                Attendance
            </a>
            <a href="{{route('overtime')}}" onclick="abort()" class="leftbar-nav-button theme-primary-a1 br-10 d-flex ai-center fs-12 fw-bold clr-grey-2 cursor-pointer @yield('overtime-button-class')">
                <span class="material-symbols-outlined mg-r-10">more_time</span>
                Overtime
            </a>
            <a href="{{route('request')}}" onclick="abort()" class="leftbar-nav-button theme-primary-a1 br-10 d-flex ai-center fs-12 fw-bold clr-grey-2 cursor-pointer @yield('request-button-class')">
                <span class="material-symbols-outlined mg-r-10">work_history</span>
                Request
            </a>
            <a href="{{route('leave')}}" onclick="abort()" class="leftbar-nav-button theme-primary-a1 br-10 d-flex ai-center fs-12 fw-bold clr-grey-2 cursor-pointer @yield('leave-button-class')">
                <span class="material-symbols-outlined mg-r-10">event_available</span>
                Leave
            </a>
            <a href="{{route('report')}}" onclick="abort()" class="leftbar-nav-button theme-primary-a1 br-10 d-flex ai-center fs-12 fw-bold clr-grey-2 cursor-pointer @yield('report-button-class')">
                <span class="material-symbols-outlined mg-r-10">description</span>
                Report
            </a>
            <a href="{{route('users')}}" onclick="abort()" class="leftbar-nav-button theme-primary-a1 br-10 d-flex ai-center fs-12 fw-bold clr-grey-2 cursor-pointer @yield('users-button-class')">
                <span class="material-symbols-outlined mg-r-10">group</span>
                Users
            </a>
            <a href="{{route('settings')}}" onclick="abort()" class="leftbar-nav-button theme-primary-a1 br-10 d-flex ai-center fs-12 fw-bold clr-grey-2 cursor-pointer @yield('settings-button-class')">
                <span class="material-symbols-outlined mg-r-10">settings</span>
                Settings
            </a>
            <a href="{{route('profile')}}" onclick="abort()" class="leftbar-nav-button theme-primary-a1 br-10 d-flex ai-center fs-12 fw-bold clr-grey-2 cursor-pointer @yield('profile-button-class')">
                <span class="material-symbols-outlined mg-r-10">assignment_ind</span>
                Profile
            </a>
            <a href="{{route('archive')}}" onclick="abort()" class="leftbar-nav-button theme-primary-a1 br-10 d-flex ai-center fs-12 fw-bold clr-grey-2 cursor-pointer @yield('archive-button-class')">
                <span class="material-symbols-outlined mg-r-10">sell</span>
                Archive
            </a>
            <a href="{{route('hcp')}}" onclick="abort()" class="leftbar-nav-button theme-primary-a1 br-10 d-flex ai-center fs-12 fw-bold clr-grey-2 cursor-pointer @yield('hcp-button-class')">
                <span class="material-symbols-outlined mg-r-10">door_front</span>
                HikCentral Professional
            </a>
        </div>
    </div>

    <div class="header h-50">
        <div class="header-left h-100p d-flex">
            <div class="h-100p mg-l-20 d-flex-center fs-16 fw-bold">@yield('tab-name')</div>
            <div class="separator h-30 mg-t-10 w-10 mg-l-20 mg-r-20" style="background-color:#eee; width:1px;"></div>
            <div class="h-100p d-flex-center">@yield('header-left')</div>
            
        </div>
        <div id="profile-button" class="header-nav h-100p w-200 d-flex cursor-pointer">
            <div class="h-50 w-50 d-flex-center">
                <img class="w-35 h-35 br-50p bg-primary" src="/images/avatar.png" style="overflow: hidden;">
            </div>
            <div class="fd-column w-150">
                <div class="name mg-t-10 mg-l-5 fs-11 fw-bold clr-black-1">{{Auth::user()->name}}</div>
                <div class="mg-l-5 fs-11 fw-bold clr-grey-2">{{Auth::user()->position}}</div>
            </div>
        </div>
    </div>
    <div id="profile-dropdown" class="dropdown w-150 pd-b-10">
        <div class="option fs-12 clr-grey-1 cursor-pointer" onclick="">Profile</div>
        <form method="POST" action="{{ route('logout') }}">
        @csrf
        @method('POST')
            <button type="submit" class="option w-100p txt-l fs-12 clr-grey-1 cursor-pointer" onclick="" style="border:none;">Logout</button>
        </form>
    </div>

    <div class="main-body">
        @yield('main-body')
    </div>

    <div id="transparent" class="transparent"></div>
    @yield('body-box')

    <script>
        function open_popup_click(popup_id) {
            document.getElementById(popup_id).classList.add('active');
            document.getElementById('transparent').classList.add('active');
        }

        function close_popup_click(popup_id) {
            document.getElementById(popup_id).classList.remove('active');
            document.getElementById('transparent').classList.remove('active');
        }

        function add_dropdown_event(button_id, dropdown_id){
            let button_element = document.getElementById(button_id);
            let dropdown_element = document.getElementById(dropdown_id);
            button_element.addEventListener('click', (e) => {
                dropdown_element.classList.toggle('active');
                button_element.classList.toggle('active');
            });
            window.addEventListener('blur', (e) => {
                dropdown_element.classList.remove('active');
                button_element.classList.remove('active');
            });
            dropdown_element.addEventListener('click', (event) => {
                event.stopPropagation();
            });
            document.addEventListener('click', (event) => {
                if (!button_element.contains(event.target)) {
                    dropdown_element.classList.remove('active');
                    button_element.classList.remove('active');
                }
            });
        }

        function add_search(input_id, dropdown_id){
            document.getElementById(input_id).addEventListener('input', function() {
                const input = this.value.toLowerCase();
                const options = document.querySelectorAll('#' + dropdown_id + ' .option');
                options.forEach(function(option) {
                    if (option.textContent.toLowerCase().includes(input)) {
                        option.style.display = '';
                    } else {
                        option.style.display = 'none';
                    }
                });
            });
        }
        
        function foreign_data_option_click(button_id, dropdown_id, input_id, value, foreign_data){
            option_click(button_id, dropdown_id, value);
            document.getElementById(input_id).value = foreign_data.id;
        }

        function option_click(button_id, dropdown_id, value){
            const button = document.getElementById(button_id);
            const dropdown = document.getElementById(dropdown_id);

            button.classList.remove('active');
            dropdown.classList.remove('active');
            button.textContent  = value;
        }

        function render_calendar(button_id, dropdown_id, input_id, date) {
            const current_month_year = document.querySelector('#' + dropdown_id + ' .current-month-year');
            const calendar_days = document.querySelector('#' + dropdown_id + ' .calendar-days');

            calendar_days.innerHTML = '';

            day_name = ['S','M','T','W','T','F','S'];
            for (let i = 0; i < day_name.length; i++) {
                const day = document.createElement('div');
                day.textContent = day_name[i];
                day.className = 'fw-bold';
                calendar_days.appendChild(day);
            }
            current_month_year.textContent = `${date.toLocaleString('default', { month: 'long' })} ${date.getFullYear()}`;
            const firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
            const lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            const startDay = firstDay.getDay();
            const endDay = lastDay.getDate();
            for (let i = 0; i < startDay; i++) {
                calendar_days.appendChild(document.createElement('div'));
            }
            const options = { weekday:'long', day:'numeric', month:'long', year:'numeric' };
            for (let i = 1; i <= endDay; i++) {
                const dayElement = document.createElement('div');
                dayElement.textContent = i;

                const date_copy = new Date(date.getFullYear(), date.getMonth(), i);
                const dateFormatter = new Intl.DateTimeFormat('en-GB', options);
                const parts = dateFormatter.formatToParts(date_copy);
                const dayName = parts.find(part => part.type === 'weekday').value;
                const day = parts.find(part => part.type === 'day').value;
                const month = parts.find(part => part.type === 'month').value;
                const year = parts.find(part => part.type === 'year').value;
                const formattedDate = `${dayName}, ${day} ${month} ${year}`;

                dayElement.addEventListener('click', function() {
                    date_option_click(button_id, dropdown_id, input_id, formattedDate, date_copy);
                });
                dayElement.className = 'clr-grey-1'
                dayElement.classList.add('valid');
                calendar_days.appendChild(dayElement);
            }
        }

        function add_calendar(button_id, dropdown_id, input_id){
            date = new Date()
            render_calendar(button_id, dropdown_id, input_id, date);
            const previous_month_button = document.querySelector('#' + dropdown_id + ' .previous-month');
            const next_month_button = document.querySelector('#' + dropdown_id + ' .next-month');
            previous_month_button.addEventListener('click', function() { 
                date.setMonth(date.getMonth() - 1);
                render_calendar(button_id, dropdown_id, input_id, date);
            });
            next_month_button.addEventListener('click', function() { 
                date.setMonth(date.getMonth() + 1);
                render_calendar(button_id, dropdown_id, input_id, date);
            });

            const options = { weekday:'long', day:'numeric', month:'long', year:'numeric' };
            const date_copy = new Date();
            const dateFormatter = new Intl.DateTimeFormat('en-GB', options);
            const parts = dateFormatter.formatToParts(date_copy);
            const dayName = parts.find(part => part.type === 'weekday').value;
            const day = parts.find(part => part.type === 'day').value;
            const month = parts.find(part => part.type === 'month').value;
            const year = parts.find(part => part.type === 'year').value;
            const formattedDate = `${dayName}, ${day} ${month} ${year}`;
            document.getElementById(button_id).textContent = formattedDate;
        }

        add_dropdown_event('profile-button', 'profile-dropdown');
        
    </script>
    @stack('script')
</body>
</html>