@extends('layouts.app')

@push('script')
    <style>
    </style>
@endpush

@section('overtime-button-class', 'active')

@section('tab-name', 'Overtime')

@section('header-left')
    <div onclick="add_overtime_click('add-popup')" class="h-10 bg-plt1 d-flex ai-center fs-12 fw-bold pd-10 pd-l-5 br-5 clr-white cursor-pointer"><span class="material-symbols-outlined mg-r-5 fw-bold">add</span>Add</div>
@endsection

@section('main-body')
    <div id="personal" class="tab active h-100p w-100p of-auto">
        <div class="of-auto">
            <table class="table-1 mg-40">
                <tr>
                    <th></th>
                    <th>Name</th>
                    <th>Start</th>
                    <th>End</th>
                    <th>Total</th>
                    <th>Description</th>
                    <th>Location</th>
                    <th>Status</th>
                </tr>

                @php $counter = 1; @endphp
                @foreach ($overtimes as $ot)
                    <tr>
                        <td>
                            <div class="d-flex-center">
                                <div class="theme-primary-2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4">{{$counter}}</div>
                            </div>
                        </td>
                        <td>
                            <div class="d-flex">
                                <div class="d-flex-center">
                                    <div class="d-flex-center br-50p bg-plt1 w-40 h-40">
                                        @if ($ot['user']['profile_picture_path'])
                                            <img src="{{asset('storage' . $ot['user']['profile_picture_path'])}}" alt="" class="w-100p h-100p br-50p" style="object-fit:cover;border:none;">
                                        @endif
                                    </div>
                                </div>
                                <div class="mg-l-15 fs-12 fw-bold">
                                    <div class="" style="text-transform: uppercase;">
                                        {{$ot['user']['name']}}
                                    </div>
                                    <div class="clr-grey-2 mg-t-5">
                                        {{$ot['user']['position']}}
                                    </div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div class="fs-12 clr-grey-1 tw-nowrap">
                                <div>{{date('d F Y', strtotime($ot['start']))}}</div>
                                <div>{{date('h:i A', strtotime($ot['start']))}}</div>
                            </div>
                        </td>
                        <td>
                            <div class="fs-12 clr-grey-1 tw-nowrap">
                                <div>{{date('d F Y', strtotime($ot['end']))}}</div>
                                <div>{{date('h:i A', strtotime($ot['end']))}}</div>
                            </div>
                        </td>
                        <td>
                            <div class="fs-12 clr-grey-1 tw-nowrap">
                                @php
                                    $diffInSeconds = strtotime($ot['end']) - strtotime($ot['start']);
                                    $totalHours = floor($diffInSeconds / 3600);
                                    $totalMinutes = floor(($diffInSeconds % 3600) / 60);
                                    if ($totalMinutes == 0) {
                                        echo $totalHours . " hours";
                                    } else {
                                        echo $totalHours . " hours " . $totalMinutes . " minutes";
                                    }
                                @endphp
                            </div>
                        </td>
                        <td>
                            <div class="fs-12 clr-grey-1">{{$ot['description']}}</div>
                        </td>
                        <td>
                            <div class="fs-12 clr-grey-1">{{$ot['location']}}</div>
                        </td>
                        <td>
                            @php
                                if ($ot['status'] == 'Approved') {
                                    echo "<div class='pd-5 br-4 txt-c fs-11 fw-bold clr-green bg-green-lite'>Approved</div>";
                                } elseif ($ot['status'] == 'Pending') {
                                    echo "<div class='pd-5 br-4 txt-c fs-11 fw-bold clr-yellow bg-yellow-lite'>Pending</div>";
                                } else {
                                    echo "<div class='pd-5 br-4 txt-c fs-11 fw-bold clr-red bg-red-lite'>Rejected</div>";
                                }
                            @endphp
                        </td>
                    </tr>
                    @php $counter++; @endphp
                @endforeach
            </table>
        </div>
    </div>
@endsection

@section('body-box')
    <div id="add-popup" class="right-popup bg-primary w-600 h-100p of-auto">
        <form  action="{{route('overtime.create')}}" method="POST">
        @csrf
        @method('POST')

        <div class="content w-100p" style="height: calc(100% - 80px);">
            <div class="h-100p pd-30"  style="width: calc(100% - 60px);">
                <div class="fs-18 clr-grey-2 fw-bold">New Request</div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-30">User <span style="color:red;">*</span></div>
                <button type="button" id="user-name-dropdown-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-8 pd-lr-0">{{strtoupper($users[0]['name'])}}</button>
                <input type="hidden" id="user-name-input" name="user_id" value="{{$users[0]['id']}}">
                <div id="user-name-dropdown" class="dropdown w-300 pd-b-10">
                    <div class="d-flex">
                        <input type="text" name="" id="user-name-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                        <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                    </div>
                    @foreach ($users as $user)
                        <div class="option fs-12 clr-grey-1 cursor-default" onclick="foreign_data_option_click('user-name-dropdown-button', 'user-name-dropdown', 'user-name-input', this.textContent, {{$user}})">{{strtoupper($user['name'])}}</div>
                    @endforeach
                </div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Date <span style="color:red;">*</span></div>
                <button type="button" id="start-date-dropdown-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-8 pd-lr-0"></button>
                <input type="hidden" id="start-date-time-input" name="start" value="{{ date('Y-m-d') }} 16:30:00">
                <div id="start-date-dropdown" class="calendar-container">
                    <div class="calendar-header">
                        <button type="button" class="previous-month br-50p w-25 h-25 d-flex-center cursor-pointer bg-plt1" style="border:none;"><span class="material-symbols-outlined fw-bold clr-white">chevron_left</span></button>
                        <span class="current-month-year fs-14 fw-bold"></span>
                        <button type="button" class="next-month br-50p w-25 h-25 d-flex-center cursor-pointer bg-plt1" style="border:none;"><span class="material-symbols-outlined fw-bold clr-white">chevron_right</span></button>
                    </div>
                    <div class="calendar-days"></div>
                </div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Time <span style="color:red;">*</span></div>
                <div class="d-flex">
                    <div>
                        <button type="button" id="start-time-hour-dropdown-button" class="dropdown-button-1 w-96 clr-black-1 pd-tb-8 pd-lr-0">04</button>
                        <div id="start-time-hour-dropdown" class="dropdown w-96 pd-b-10">
                            @for ($i = 1; $i <= 12; $i++)
                                <div class="option fs-12 clr-grey-1 cursor-default" onclick="time_option_click('start-time-hour-dropdown-button', 'start-time-minute-dropdown-button', 'start-time-phase-dropdown-button', 'start-time-hour-dropdown', 'start-date-time-input', this.textContent, 'hour')">{{ sprintf('%02d', $i) }}</div>
                            @endfor
                        </div>
                    </div>
                    
                    <div>
                        <button type="button" id="start-time-minute-dropdown-button" class="dropdown-button-1 w-96 mg-l-6 clr-black-1 pd-tb-8 pd-lr-0">30</button>
                        <div id="start-time-minute-dropdown" class="dropdown w-96 mg-l-6 pd-b-10">
                            @for ($i = 0; $i <= 59; $i++)
                                <div class="option fs-12 clr-grey-1 cursor-default" onclick="time_option_click('start-time-hour-dropdown-button', 'start-time-minute-dropdown-button', 'start-time-phase-dropdown-button', 'start-time-minute-dropdown', 'start-date-time-input', this.textContent, 'minute')">{{ sprintf('%02d', $i) }}</div>
                            @endfor
                        </div>
                    </div>

                    <div>
                        <button type="button" id="start-time-phase-dropdown-button" class="dropdown-button-1 w-96 mg-l-6 clr-black-1 pd-tb-8 pd-lr-0">PM</button>
                        <div id="start-time-phase-dropdown" class="dropdown w-96 mg-l-6 pd-b-10">
                            <div class="option fs-12 clr-grey-1 cursor-default" onclick="time_option_click('start-time-hour-dropdown-button', 'start-time-minute-dropdown-button', 'start-time-phase-dropdown-button', 'start-time-phase-dropdown', 'start-date-time-input', this.textContent, 'phase')">AM</div>
                            <div class="option fs-12 clr-grey-1 cursor-default" onclick="time_option_click('start-time-hour-dropdown-button', 'start-time-minute-dropdown-button', 'start-time-phase-dropdown-button', 'start-time-phase-dropdown', 'start-date-time-input', this.textContent, 'phase')">PM</div>
                        </div>
                    </div>
                </div>
                
                <div class="fs-13 clr-black-1 fw-bold mg-t-20">End Date <span style="color:red;">*</span></div>
                <button type="button" id="end-date-dropdown-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-8 pd-lr-0">Hehe</button>
                <input type="hidden" id="end-date-time-input" name="end" value="{{ date('Y-m-d') }} 17:30:00">
                <div id="end-date-dropdown" class="calendar-container">
                    <div class="calendar-header">
                        <button type="button" class="previous-month br-50p w-25 h-25 d-flex-center cursor-pointer bg-plt1" style="border:none;"><span class="material-symbols-outlined fw-bold clr-white">chevron_left</span></button>
                        <span class="current-month-year fs-14 fw-bold"></span>
                        <button type="button" class="next-month br-50p w-25 h-25 d-flex-center cursor-pointer bg-plt1" style="border:none;"><span class="material-symbols-outlined fw-bold clr-white">chevron_right</span></button>
                    </div>
                    <div class="calendar-days"></div>
                </div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">End Time <span style="color:red;">*</span></div>
                <div class="d-flex">
                    <div>
                        <button type="button" id="end-time-hour-dropdown-button" class="dropdown-button-1 w-96 clr-black-1 pd-tb-8 pd-lr-0">05</button>
                        <div id="end-time-hour-dropdown" class="dropdown w-96 pd-b-10">
                            @for ($i = 1; $i <= 12; $i++)
                                <div class="option fs-12 clr-grey-1 cursor-default" onclick="time_option_click('end-time-hour-dropdown-button', 'end-time-minute-dropdown-button', 'end-time-phase-dropdown-button', 'end-time-hour-dropdown', 'end-date-time-input', this.textContent, 'hour')">{{ sprintf('%02d', $i) }}</div>
                            @endfor
                        </div>
                    </div>
                    
                    <div>
                        <button type="button" id="end-time-minute-dropdown-button" class="dropdown-button-1 w-96 mg-l-6 clr-black-1 pd-tb-8 pd-lr-0">30</button>
                        <div id="end-time-minute-dropdown" class="dropdown w-96 pd-b-10">
                            @for ($i = 0; $i <= 59; $i++)
                                <div class="option fs-12 clr-grey-1 cursor-default" onclick="time_option_click('end-time-hour-dropdown-button', 'end-time-minute-dropdown-button', 'end-time-phase-dropdown-button', 'end-time-minute-dropdown', 'end-date-time-input', this.textContent, 'minute')">{{ sprintf('%02d', $i) }}</div>
                            @endfor
                        </div>
                    </div>

                    <div>
                        <button type="button" id="end-time-phase-dropdown-button" class="dropdown-button-1 w-96 mg-l-6 clr-black-1 pd-tb-8 pd-lr-0">PM</button>
                        <div id="end-time-phase-dropdown" class="dropdown w-96 mg-l-6 pd-b-10">
                            <div class="option fs-12 clr-grey-1 cursor-default" onclick="time_option_click('end-time-hour-dropdown-button', 'end-time-minute-dropdown-button', 'end-time-phase-dropdown-button', 'end-time-phase-dropdown', 'end-date-time-input', this.textContent, 'phase')">AM</div>
                            <div class="option fs-12 clr-grey-1 cursor-default" onclick="time_option_click('end-time-hour-dropdown-button', 'end-time-minute-dropdown-button', 'end-time-phase-dropdown-button', 'end-time-phase-dropdown', 'end-date-time-input', this.textContent, 'phase')">PM</div>
                        </div>
                    </div>
                </div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Description <span style="color:red;">*</span></div>
                <textarea class="textarea-1 w-300 h-100 mg-t-8 br-2" style="max-width:300px;min-width:300px;font-family:Arial" name="description"></textarea>

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Location</div>
                <input type="text" id="personal-user-input" name="location" class="dropdown-button-1 w-300 clr-black-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">

            </div>
        </div>
        <div class="submit-section h-80 w-100p">
            <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                <button type="submit" class="bg-btn-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                <button type="button" onclick="cancel_add_overtime_click('add-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
            </div>
        </div>
        </form>
    </div>
@endsection

@push('script')
    <script>
        function add_overtime_click(popup_id) {
            document.getElementById(popup_id).classList.add('active');
            document.getElementById('transparent').classList.add('active');
        }

        function cancel_add_overtime_click(popup_id) {
            document.getElementById(popup_id).classList.remove('active');
            document.getElementById('transparent').classList.remove('active');
        }

        add_search('user-name-search', 'user-name-dropdown');

        add_dropdown_event('user-name-dropdown-button', 'user-name-dropdown');
        add_dropdown_event('start-date-dropdown-button', 'start-date-dropdown');
        add_dropdown_event('start-time-hour-dropdown-button', 'start-time-hour-dropdown');
        add_dropdown_event('start-time-minute-dropdown-button', 'start-time-minute-dropdown');
        add_dropdown_event('start-time-phase-dropdown-button', 'start-time-phase-dropdown');
        add_dropdown_event('end-date-dropdown-button', 'end-date-dropdown');
        add_dropdown_event('end-time-hour-dropdown-button', 'end-time-hour-dropdown');
        add_dropdown_event('end-time-minute-dropdown-button', 'end-time-minute-dropdown');
        add_dropdown_event('end-time-phase-dropdown-button', 'end-time-phase-dropdown');

        
        function date_option_click(button_id, dropdown_id, input_id, value, date){
            option_click(button_id, dropdown_id, value);
            
            const year = date.getFullYear();
            const month = String(date.getMonth() + 1).padStart(2, '0');
            const day = String(date.getDate()).padStart(2, '0');
            const formattedDate = `${year}-${month}-${day}`;

            dateTime = document.getElementById(input_id).value;
            const timePart = dateTime.split(' ')[1]
            const updatedDateTime = `${formattedDate} ${timePart}`;
            document.getElementById(input_id).value = updatedDateTime;
        }

        function time_option_click(button_hour_id, button_minute_id, button_phase_id, dropdown_id, input_id, value, time_type){
            switch (time_type){
                case 'hour': option_click(button_hour_id, dropdown_id, value); break;
                case 'minute': option_click(button_minute_id, dropdown_id, value); break;
                case 'phase': option_click(button_phase_id, dropdown_id, value); break;
            }
            let hour = document.getElementById(button_hour_id).textContent;
            let minute = document.getElementById(button_minute_id).textContent;
            let phase = document.getElementById(button_phase_id).textContent;
            if (hour === '12') {hour = '00';}
            if (phase === 'PM') {hour = String(parseInt(hour, 10) + 12);}
            formattedTime = `${hour}:${minute}:00`;

            dateTime = document.getElementById(input_id).value;
            const datePart = dateTime.split(' ')[0];
            const updatedDateTime = `${datePart} ${formattedTime}`;
            document.getElementById(input_id).value = updatedDateTime;
        }

        add_calendar('start-date-dropdown-button', 'start-date-dropdown', 'start-date-time-input');
        add_calendar('end-date-dropdown-button', 'end-date-dropdown', 'end-date-time-input');

    </script>
@endpush