@extends('layouts.app')

@push('script')
    <style>
        .report-button {
            box-shadow: 0px 0px 10px 0px #00000022;
            transition: box-shadow 0.3s;
        }

        .report-button:hover {
            box-shadow: 0px 0px 15px 10px #00000033;
        }

        .download-button {
            position: absolute;
            right: 40px;
            top: 20px;
        }

    </style>
@endpush

@section('report-button-class', 'active')

@section('tab-name', 'Report')

@section('header-left')
@endsection

@section('main-body')
    <div id="personal" class="tab active h-100p w-100p of-auto">
        <div class="d-flex pd-30" style="flex-wrap:wrap;">
            <div onclick="report_click('personal-popup')" class="report-button d-flex bg-primary w-350 h-130 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-150 bg-plt1 of-hidden d-flex-center" style="flex-shrink:0;">
                    <img class="w-100p h-100p" style="object-fit: cover;" src="{{asset('images/bg-statistics.jpg')}}" alt="">
                </div>
                <div class="h-100p w-160 pd-20">
                    <div class="fs-16 fw-bold clr-primary">Personal</div>
                    <div class="fs-12 fw-bold clr-grey-2">Personal attendance status with date</div>
                </div>
            </div>
            <div onclick="report_click('attendance-popup')" class="report-button d-flex bg-primary w-350 h-130 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-150 bg-plt1" style="flex-shrink:0;">
                    <img class="w-100p h-100p" style="object-fit: cover;" src="{{asset('images/bg-report.jpg')}}" alt="">
                </div>
                <div class="h-100p w-160 pd-20">
                    <div class="fs-16 fw-bold clr-primary">Attendance</div>
                    <div class="fs-12 fw-bold clr-grey-2">Daily attendance status with date range</div>
                </div>
            </div>
            <div onclick="report_click('request-popup')" class="report-button d-flex bg-primary w-350 h-130 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-150 bg-plt1" style="flex-shrink:0;">
                    <img class="w-100p h-100p" style="object-fit: cover;" src="{{asset('images/bg-outstation.jpg')}}" alt="">
                </div>
                <div class="h-100p w-160 pd-20">
                    <div class="fs-16 fw-bold clr-primary">Request</div>
                    <div class="fs-12 fw-bold clr-grey-2">Outstation or work from home request with date range</div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('body-box')
    <div id="personal-popup" class="right-popup bg-primary w-600 h-100p of-auto">
        <div class="content w-100p" style="height: calc(100% - 80px);">
            <div class="h-100p pd-30"  style="width: calc(100% - 60px);">
                <div class="fs-18 clr-grey-2 fw-bold">Personal Report</div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-30">User <span style="color:red;">*</span></div>
                <button type="button" id="personal-user-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Hehe <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-user-input" name="user">
                <!-- <div id="personal-user-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Date <span style="color:red;">*</span></div>
                <button type="button" id="personal-start-date-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Day_name, day month year <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-start-date-input" name="user">
                <!-- <div id="personal-start-date-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-20"">End Date <span style="color:red;">*</span></div>
                <button type="button" id="personal-end-date-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Day_name, day month year <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-end-date-input" name="user">
                <!-- <div id="personal-end-date-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->
            </div>
        </div>
        <div class="submit-section h-80 w-100p">
            <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                <button class="bg-btn-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Preview</button>
                <button onclick="cancel_report_click('personal-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
            </div>
            <button class="download-button bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Download</button>
        </div>
    </div>

    <div id="attendance-popup" class="right-popup bg-primary w-600 h-100p of-auto">
        <div class="content w-100p" style="height: calc(100% - 80px);">
            <div class="h-100p pd-30"  style="width: calc(100% - 60px);">
                <div class="fs-18 clr-grey-2 fw-bold">Attendance Report</div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-30">Keyword</div>
                <button type="button" id="personal-user-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Hehe <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-user-input" name="user">
                <!-- <div id="personal-user-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-30">Office</div>
                <button type="button" id="personal-user-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Hehe <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-user-input" name="user">
                <!-- <div id="personal-user-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-30">Division</div>
                <button type="button" id="personal-user-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Hehe <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-user-input" name="user">
                <!-- <div id="personal-user-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-30">Department</div>
                <button type="button" id="personal-user-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Hehe <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-user-input" name="user">
                <!-- <div id="personal-user-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-30">Unit</div>
                <button type="button" id="personal-user-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Hehe <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-user-input" name="user">
                <!-- <div id="personal-user-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Date <span style="color:red;">*</span></div>
                <button type="button" id="personal-start-date-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Day_name, day month year <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-start-date-input" name="user">
                <!-- <div id="personal-start-date-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-20"">End Date <span style="color:red;">*</span></div>
                <button type="button" id="personal-end-date-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Day_name, day month year <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-end-date-input" name="user">
                <!-- <div id="personal-end-date-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->
            </div>
        </div>
        <div class="submit-section h-80 w-100p">
            <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                <button class="bg-btn-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Preview</button>
                <button onclick="cancel_report_click('attendance-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
            </div>
            <button class="download-button bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Download</button>
        </div>
    </div>

    <div id="request-popup" class="right-popup bg-primary w-600 h-100p of-auto">
        <div class="content w-100p" style="height: calc(100% - 80px);">
            <div class="h-100p pd-30"  style="width: calc(100% - 60px);">
                <div class="fs-18 clr-grey-2 fw-bold">Attendance Report</div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-30">Keyword</div>
                <button type="button" id="personal-user-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Hehe <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-user-input" name="user">
                <!-- <div id="personal-user-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-30">Office</div>
                <button type="button" id="personal-user-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Hehe <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-user-input" name="user">
                <!-- <div id="personal-user-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-30">Division</div>
                <button type="button" id="personal-user-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Hehe <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-user-input" name="user">
                <!-- <div id="personal-user-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-30">Department</div>
                <button type="button" id="personal-user-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Hehe <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-user-input" name="user">
                <!-- <div id="personal-user-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-30">Unit</div>
                <button type="button" id="personal-user-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Hehe <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-user-input" name="user">
                <!-- <div id="personal-user-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Date <span style="color:red;">*</span></div>
                <button type="button" id="personal-start-date-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Day_name, day month year <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-start-date-input" name="user">
                <!-- <div id="personal-start-date-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->

                <div class="fs-13 clr-black-1 fw-bold mg-t-20"">End Date <span style="color:red;">*</span></div>
                <button type="button" id="personal-end-date-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-10 pd-lr-0">Day_name, day month year <span class="material-symbols-outlined icon">close</span></button>
                <input type="hidden" id="personal-end-date-input" name="user">
                <!-- <div id="personal-end-date-dropdown" class="dropdown">
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Jura</div>
                    <div class="option" onclick="option_click('pdf-font', this.textContent)">Roboto</div>
                </div> -->
            </div>
        </div>
        <div class="submit-section h-80 w-100p">
            <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                <button class="bg-btn-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Preview</button>
                <button onclick="cancel_report_click('request-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
            </div>
            <button class="download-button bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Download</button>
        </div>
    </div>
@endsection

@push('script')
    <script>
        function report_click(popup_id) {
            document.getElementById(popup_id).classList.add('active');
            document.getElementById('transparent').classList.add('active');
        }

        function cancel_report_click(popup_id) {
            document.getElementById(popup_id).classList.remove('active');
            document.getElementById('transparent').classList.remove('active');
        }
    </script>
@endpush