@extends('layouts.app')

@push('script')
    <style>
        .setting-button {
            /* box-shadow: 0px 0px 10px 0px #00000033; */
            transition: box-shadow 0.3s;
        }

        .setting-button:hover {
            box-shadow: 0px 0px 10px 5px #00000033;
        }
    </style>
@endpush

@section('settings-button-class', 'active')

@section('tab-name', 'Settings')

@section('header-left')
@endsection

@section('main-body')
    <div id="setting-main" class="tab active w-100p">
        <div class="fs-18 clr-grey-2 fw-bold pd-l-30 pd-t-20">Application</div>
        <div class="d-flex pd-30" style="flex-wrap:wrap;">
            <div onclick="tab_click('general')" class="setting-button d-flex bg-primary w-300 h-50 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-50 d-flex-center">
                    <span class="material-symbols-outlined clr-primary fw-bold">web_asset</span>
                </div>
                <div class="h-100p w-250 d-flex fd-column jc-center">
                    <div class="fs-13 fw-bold clr-black-2">General</div>
                    <div class="fs-12 clr-grey-2">General settings for application</div>
                </div>
            </div>
            <div onclick="tab_click('announcement')" class="setting-button d-flex bg-primary w-300 h-50 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-50 d-flex-center">
                    <span class="material-symbols-outlined clr-primary fw-bold">speaker_notes</span>
                </div>
                <div class="h-100p w-250 d-flex fd-column jc-center">
                    <div class="fs-13 fw-bold clr-black-2">Announcement</div>
                    <div class="fs-12 clr-grey-2">Announcement for system user</div>
                </div>
            </div>
            <div onclick="tab_click('public-holiday')" class="setting-button d-flex bg-primary w-300 h-50 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-50 d-flex-center">
                    <span class="material-symbols-outlined clr-primary fw-bold">event</span>
                </div>
                <div class="h-100p w-250 d-flex fd-column jc-center">
                    <div class="fs-13 fw-bold clr-black-2">Public Holiday</div>
                    <div class="fs-12 clr-grey-2">Public Holiday for leave application</div>
                </div>
            </div>


        </div>

        <div class="fs-18 clr-grey-2 fw-bold pd-l-30 pd-t-20">Staff</div>
        <div class="d-flex pd-30" style="flex-wrap:wrap;">
            <div onclick="tab_click('organization')" class="setting-button d-flex bg-primary w-300 h-50 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-50 d-flex-center">
                    <span class="material-symbols-outlined clr-primary fw-bold">apartment</span>
                </div>
                <div class="h-100p w-250 d-flex fd-column jc-center">
                    <div class="fs-13 fw-bold clr-black-2">Organization</div>
                    <div class="fs-12 clr-grey-2">Organization list for system</div>
                </div>
            </div>
            <div onclick="tab_click('position')" class="setting-button d-flex bg-primary w-300 h-50 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-50 d-flex-center">
                    <span class="material-symbols-outlined clr-primary fw-bold">settings_account_box</span>
                </div>
                <div class="h-100p w-250 d-flex fd-column jc-center">
                    <div class="fs-13 fw-bold clr-black-2">Position</div>
                    <div class="fs-12 clr-grey-2">Position list for staff</div>
                </div>
            </div>
            <div onclick="tab_click('working-time')" class="setting-button d-flex bg-primary w-300 h-50 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-50 d-flex-center">
                    <span class="material-symbols-outlined clr-primary fw-bold">work_history</span>
                </div>
                <div class="h-100p w-250 d-flex fd-column jc-center">
                    <div class="fs-13 fw-bold clr-black-2">Working Time</div>
                    <div class="fs-12 clr-grey-2">Working time list for attendance</div>
                </div>
            </div>
            <div onclick="tab_click('location')" class="setting-button d-flex bg-primary w-300 h-50 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-50 d-flex-center">
                    <span class="material-symbols-outlined clr-primary fw-bold">location_on</span>
                </div>
                <div class="h-100p w-250 d-flex fd-column jc-center">
                    <div class="fs-13 fw-bold clr-black-2">Location</div>
                    <div class="fs-12 clr-grey-2">Location list for check in</div>
                </div>
            </div>
            <div onclick="tab_click('reason')" class="setting-button d-flex bg-primary w-300 h-50 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-50 d-flex-center">
                    <span class="material-symbols-outlined clr-primary fw-bold">format_list_bulleted</span>
                </div>
                <div class="h-100p w-250 d-flex fd-column jc-center">
                    <div class="fs-13 fw-bold clr-black-2">Reason</div>
                    <div class="fs-12 clr-grey-2">Common reason for staff</div>
                </div>
            </div>


        </div>

        <div class="fs-18 clr-grey-2 fw-bold pd-l-30 pd-t-20">System</div>
        <div class="d-flex pd-30" style="flex-wrap:wrap;">
            <div onclick="tab_click('smtp-relay')" class="setting-button d-flex bg-primary w-300 h-50 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-50 d-flex-center">
                    <span class="material-symbols-outlined clr-primary fw-bold">mail</span>
                </div>
                <div class="h-100p w-250 d-flex fd-column jc-center">
                    <div class="fs-13 fw-bold clr-black-2">SMTP Relay</div>
                    <div class="fs-12 clr-grey-2">SMTP relay for outgoing email</div>
                </div>
            </div>
            <div onclick="tab_click('services')" class="setting-button d-flex bg-primary w-300 h-50 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-50 d-flex-center">
                    <span class="material-symbols-outlined clr-primary fw-bold">playlist_play</span>
                </div>
                <div class="h-100p w-250 d-flex fd-column jc-center">
                    <div class="fs-13 fw-bold clr-black-2">Services</div>
                    <div class="fs-12 clr-grey-2">Services for system</div>
                </div>
            </div>
            <div onclick="tab_click('integration')" class="setting-button d-flex bg-primary w-300 h-50 mg-10 br-5 of-hidden cursor-pointer">
                <div class="h-100p w-50 d-flex-center">
                    <span class="material-symbols-outlined clr-primary fw-bold">dns</span>
                </div>
                <div class="h-100p w-250 d-flex fd-column jc-center">
                    <div class="fs-13 fw-bold clr-black-2">Integration</div>
                    <div class="fs-12 clr-grey-2">Integration settings for system</div>
                </div>
            </div>
        </div>
    </div>

    <div id="general" class="tab w-100p txt-c">
        <span class="material-symbols-outlined fw-bold" style="font-size:200px; color:#00000011">handyman</span>
        <div class="fs-20 fw-bold clr-grey-2">Under Development</div>
    </div>

    <div id="announcement" class="tab w-100p txt-c">
        <span class="material-symbols-outlined fw-bold" style="font-size:200px; color:#00000011">handyman</span>
        <div class="fs-20 fw-bold clr-grey-2">Under Development</div>
    </div>

    <div id="public-holiday" class="tab w-100p txt-c">
        <span class="material-symbols-outlined fw-bold" style="font-size:200px; color:#00000011">handyman</span>
        <div class="fs-20 fw-bold clr-grey-2">Under Development</div>
    </div>

    <div id="organization" class="tab w-100p txt-c">
        <span class="material-symbols-outlined fw-bold" style="font-size:200px; color:#00000011">handyman</span>
        <div class="fs-20 fw-bold clr-grey-2">Under Development</div>
    </div>

    <div id="position" class="tab w-100p txt-c">
        <span class="material-symbols-outlined fw-bold" style="font-size:200px; color:#00000011">handyman</span>
        <div class="fs-20 fw-bold clr-grey-2">Under Development</div>
    </div>

    <div id="working-time" class="tab w-100p txt-c">
        <span class="material-symbols-outlined fw-bold" style="font-size:200px; color:#00000011">handyman</span>
        <div class="fs-20 fw-bold clr-grey-2">Under Development</div>
    </div>

    <div id="location" class="tab w-100p txt-c">
        <span class="material-symbols-outlined fw-bold" style="font-size:200px; color:#00000011">handyman</span>
        <div class="fs-20 fw-bold clr-grey-2">Under Development</div>
    </div>

    <div id="reason" class="tab w-100p txt-c">
        <span class="material-symbols-outlined fw-bold" style="font-size:200px; color:#00000011">handyman</span>
        <div class="fs-20 fw-bold clr-grey-2">Under Development</div>
    </div>

    <div id="smtp-relay" class="tab w-100p txt-c">
        <span class="material-symbols-outlined fw-bold" style="font-size:200px; color:#00000011">handyman</span>
        <div class="fs-20 fw-bold clr-grey-2">Under Development</div>
    </div>

    <div id="services" class="tab w-100p txt-c">
        <span class="material-symbols-outlined fw-bold" style="font-size:200px; color:#00000011">handyman</span>
        <div class="fs-20 fw-bold clr-grey-2">Under Development</div>
    </div>

    <div id="integration" class="tab w-100p">
        <div class="d-flex pd-30">
            <div class="w-150 h-150 mg-10 d-flex-center fd-column" style="flex-shrink:0;">
                <div class="h-80">
                    <img class="w-100p h-100p" src="{{asset('images/app.png')}}" alt="">
                </div>
                <div class="fs-14 fw-bold mg-t-20">Hikcentral</div>
            </div>
            <div class="w-100 h-150 mg-10 d-flex-center" style="flex-shrink:0;">
                <div class="fs-11 fw-bold bg-green-lite clr-green pd-5 br-3">Connected</div>
            </div>
            <div class="w-150 h-150 mg-10 d-flex-center fd-column" style="flex-shrink:0;">
                <div class="h-80">
                    <img class="w-100p h-100p" src="{{asset('images/middleware.png')}}" alt="">
                </div>
                <div class="fs-14 fw-bold mg-t-20">Middleware</div>
            </div>
            <div class="w-100 h-150 mg-10 d-flex-center" style="flex-shrink:0;">
                <div class="fs-11 fw-bold bg-red-lite clr-red pd-5 br-3">Disconnected</div>
            </div>
            <div class="w-150 h-150 mg-10 d-flex-center fd-column" style="flex-shrink:0;">
                <div class="h-80">
                    <img class="w-100p h-100p" src="{{asset('images/database.png')}}" alt="">
                </div>
                <div class="fs-14 fw-bold mg-t-20">Database</div>
            </div>
        </div>

        <div class="d-flex pd-lr-30 mg-l-10">
            <div class="w-550" style="flex-shrink:0;">
                <div class="fs-14 clr-grey-2 fw-bold mg-b-10">HikCentral</div>
                <div class="d-flex fs-13">
                    <div class="w-100 clr-grey-2">
                        <div class="mg-t-15">Server</div>
                        <div class="mg-t-15">Key</div>
                        <div class="mg-t-15">Secret</div>
                    </div>
                    <div class="w-50 clr-black-1 fw-bold">
                        <div class="mg-t-15">{{$hik_central['url']}}</div>
                        <div class="mg-t-15">{{$hik_central['app_key']}}</div>
                        <div class="mg-t-15">****************</div>
                    </div>
                </div>
                <button type="button" onclick="open_popup_click('hikcentral-configure-popup')" class="fs-12 fw-bold mg-t-30 pd-tb-8 pd-lr-15 bg-btn-primary br-4 clr-white cursor-pointer" style="border:none">Configure</button>
            </div>
            <div class="w-300" style="flex-shrink:0;">
                <div class="fs-14 clr-grey-2 fw-bold mg-b-10">Database</div>
                <div class="d-flex fs-13">
                    <div class="w-100 clr-grey-2">
                        <div class="mg-t-15">Server</div>
                        <div class="mg-t-15">Database</div>
                        <div class="mg-t-15">Username</div>
                    </div>
                    <div class="w-50 clr-black-1 fw-bold">
                        <div class="mg-t-15">{{$database['host']}}</div>
                        <div class="mg-t-15">{{$database['database']}}</div>
                        <div class="mg-t-15">{{$database['username']}}</div>
                    </div>
                </div>
            </div>
            <div class="w-100" style="flex-shrink:0;"></div>
        </div>

    </div>
@endsection

@section('body-box')
    <div id="hikcentral-configure-popup" class="right-popup bg-primary w-600 h-100p of-auto">
        <form  action="{{route('settings.hikcentral_configure')}}" method="POST">
            @csrf
            @method('POST')

        <div class="content w-100p" style="height: calc(100% - 80px);">
            <div class="h-100p pd-30"  style="width: calc(100% - 60px);">
                <div class="fs-18 clr-grey-2 fw-bold">Configure HikCentral Connection</div>
                
                <div class="fs-13 clr-black-1 fw-bold mg-t-30">Server <span style="color:red;">*</span></div>
                <input type="text" id="" name="url" value="{{$hik_central['url']}}" class="dropdown-button-1 w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">App Key <span style="color:red;">*</span></div>
                <input type="text" id="" name="app_key" value="{{$hik_central['app_key']}}" class="dropdown-button-1 w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">App Secret <span style="color:red;">*</span></div>
                <input type="text" id="" name="app_secret" value="{{$hik_central['app_secret']}}" class="dropdown-button-1 w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">

                <!-- <div class="fs-13 clr-black-1 fw-bold mg-t-20">Event Type <span style="color:red;">*</span></div>
                <input type="text" id="" name="app_key" value="{{$hik_central['app_secret']}}" class="dropdown-button-1 w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text"> -->

                <!-- <div class="fs-18 clr-grey-2 fw-bold mg-t-40">Listener</div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">IP Address</div>
                <input type="text" id="" name="app_key" value="{{$hik_central['app_secret']}}" class="dropdown-button-1 w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Port</div>
                <input type="text" id="" name="app_key" value="{{$hik_central['app_secret']}}" class="dropdown-button-1 w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text"> -->
            </div>
        </div>
        <div class="submit-section h-80 w-100p">
            <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                <button type="submit" class="bg-btn-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Save Changes</button>
                <button type="button" onclick="close_popup_click('hikcentral-configure-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
            </div>
        </div>
        </form>
    </div>
@endsection

@push('script')
    <script>
        function tab_click(tab_id){
            document.querySelectorAll('.tab').forEach(t => {
                t.classList.remove('active');
            });
            document.getElementById(tab_id).classList.add('active');
        }
    </script>
@endpush