<?php

use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\LeaveController;
use App\Http\Controllers\OvertimeController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\RequestController;
use App\Http\Controllers\SettingController;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Route;

// Route::get('/', function () {
//     return redirect()->route('login');
// });

Route::get('/', function () {
    return view('welcome');
});

// Route::get('/dashboard', function () {
//     return view('dashboard');
// })->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::get('/dashboard', function () {return view('dashboard');})->name('dashboard');
    Route::get('/approval', function () {return view('approval');})->name('approval');
    Route::get('/attendance', [AttendanceController::class, 'index'])->name('attendance');
    Route::prefix('/attendance')->group(function () {
        Route::post('/create', [AttendanceController::class, 'create'])->name('attendance.create');
    });
    Route::get('/overtime', [OvertimeController::class, 'index'])->name('overtime');
    Route::prefix('/overtime')->group(function () {
        Route::post('/create', [OvertimeController::class, 'create'])->name('overtime.create');
    });
    Route::get('/request', [RequestController::class, 'index'])->name('request');
    Route::prefix('/request')->group(function () {
        Route::post('/create', [RequestController::class, 'create'])->name('request.create');
    });
    Route::get('/leave', [LeaveController::class, 'index'])->name('leave');
    Route::prefix('/leave')->group(function () {
        Route::post('/create', [LeaveController::class, 'create'])->name('leave.create');
    });
    Route::get('/report', function () {return view('report');})->name('report');
    Route::get('/users', function () {return view('users');})->name('users');
    Route::get('/settings', [SettingController::class, 'index'])->name('settings');
    Route::prefix('/settings')->group(function () {
        Route::post('/hikcentral-configure', [SettingController::class, 'hikcentral_configure'])->name('settings.hikcentral_configure');
    });
    Route::get('/profile', [ProfileController::class, 'index'])->name('profile');
    Route::get('/archive', function () {return view('archive');})->name('archive');
    Route::get('/hcp', function () {return view('hcp');})->name('hcp');

    // HIK CENTRAL PROFESSIONAL API 
    Route::post('/artemis/api/resource/v1/person/personList', function (Request $request) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $appKey = env('HIKCENTRAL_APP_KEY');
        $appSecret = env('HIKCENTRAL_APP_SECRET');
        $method = 'POST';
        $contentType = 'application/json';
        $date = Carbon::now('GMT')->format('D, d M Y H:i:s \G\M\T');
        $uri = '/artemis/api/resource/v1/person/personList';
        $body = json_encode([
            'pageNo' => 1,
            'pageSize' => 100
        ]);

        // Generate Content-MD5
        $contentMd5 = base64_encode(md5($body, true));

        // Create the string to sign
        $stringToSign = "{$method}\n" .
                        "*/*\n" .
                        "{$contentMd5}\n" .
                        "{$contentType}\n" .
                        "{$date}\n" .
                        "x-ca-key:{$appKey}\n" .
                        "x-ca-timestamp:" . now()->timestamp * 1000 . "\n" .
                        $uri;

        // Generate the HmacSHA256 signature
        $signature = base64_encode(hash_hmac('sha256', $stringToSign, $appSecret, true));
        
        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, [
                'headers' => [
                    'Accept' => '*/*',
                    'Content-MD5' => $contentMd5,
                    'Content-Type' => $contentType,
                    'Date' => $date,
                    'X-Ca-Key' => $appKey,
                    'X-Ca-Signature' => $signature,
                    'X-Ca-Timestamp' => now()->timestamp * 1000,
                    'X-Ca-Signature-Headers' => 'x-ca-key,x-ca-timestamp',
                ],
                'body' => $body,
            ]);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    });
    Route::post('/artemis/api/resource/v1/person/picture_data', function (Request $request) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $appKey = env('HIKCENTRAL_APP_KEY');
        $appSecret = env('HIKCENTRAL_APP_SECRET');
        $method = 'POST';
        $contentType = 'application/json';
        $date = Carbon::now('GMT')->format('D, d M Y H:i:s \G\M\T');
        $uri = '/artemis/api/resource/v1/person/picture_data';
        $body = json_encode([
            'personId' => $request->input('personId'),
            'picUri' => $request->input('picUri')
        ]);

        // Generate Content-MD5
        $contentMd5 = base64_encode(md5($body, true));

        // Create the string to sign
        $stringToSign = "{$method}\n" .
                        "*/*\n" .
                        "{$contentMd5}\n" .
                        "{$contentType}\n" .
                        "{$date}\n" .
                        "x-ca-key:{$appKey}\n" .
                        "x-ca-timestamp:" . now()->timestamp * 1000 . "\n" .
                        $uri;

        // Generate the HmacSHA256 signature
        $signature = base64_encode(hash_hmac('sha256', $stringToSign, $appSecret, true));
        
        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, [
                'headers' => [
                    'Accept' => '*/*',
                    'Content-MD5' => $contentMd5,
                    'Content-Type' => $contentType,
                    'Date' => $date,
                    'X-Ca-Key' => $appKey,
                    'X-Ca-Signature' => $signature,
                    'X-Ca-Timestamp' => now()->timestamp * 1000,
                    'X-Ca-Signature-Headers' => 'x-ca-key,x-ca-timestamp',
                    'domainId' => 1,
                ],
                'body' => $body,
            ]);
            
            // $data = json_decode($response->getBody(), true);
            // return response()->json($response);
            $responseBody = $response->getBody()->getContents();
            Log::info('Raw Response: ' . $responseBody);
            return response($responseBody, 200)->header('Content-Type', 'text/xml');
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    });
    Route::post('/artemis/api/resource/v1/acsDoor/acsDoorList', function (Request $request) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $appKey = env('HIKCENTRAL_APP_KEY');
        $appSecret = env('HIKCENTRAL_APP_SECRET');
        $method = 'POST';
        $contentType = 'application/json';
        $date = Carbon::now('GMT')->format('D, d M Y H:i:s \G\M\T');
        $uri = '/artemis/api/resource/v1/acsDoor/acsDoorList';
        $body = json_encode([
            "pageNo" => 1,
            "pageSize" => 2
        ]);

        // Generate Content-MD5
        $contentMd5 = base64_encode(md5($body, true));

        // Create the string to sign
        $stringToSign = "{$method}\n" .
                        "*/*\n" .
                        "{$contentMd5}\n" .
                        "{$contentType}\n" .
                        "{$date}\n" .
                        "x-ca-key:{$appKey}\n" .
                        "x-ca-timestamp:" . now()->timestamp * 1000 . "\n" .
                        $uri;

        // Generate the HmacSHA256 signature
        $signature = base64_encode(hash_hmac('sha256', $stringToSign, $appSecret, true));
        
        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, [
                'headers' => [
                    'Accept' => '*/*',
                    'Content-MD5' => $contentMd5,
                    'Content-Type' => $contentType,
                    'Date' => $date,
                    'X-Ca-Key' => $appKey,
                    'X-Ca-Signature' => $signature,
                    'X-Ca-Timestamp' => now()->timestamp * 1000,
                    'X-Ca-Signature-Headers' => 'x-ca-key,x-ca-timestamp',
                ],
                'body' => $body,
            ]);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    });
    Route::post('/artemis/api/acs/v1/door/events', function (Request $request) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $appKey = env('HIKCENTRAL_APP_KEY');
        $appSecret = env('HIKCENTRAL_APP_SECRET');
        $method = 'POST';
        $contentType = 'application/json';
        $date = Carbon::now('GMT')->format('D, d M Y H:i:s \G\M\T');
        $uri = '/artemis/api/acs/v1/door/events';
        $body = json_encode([
            "startTime"=> $request->input('startTime'),
            "endTime"=> $request->input('endTime'),
            "eventType"=> $request->input('eventType'),
            "personName"=> $request->input('personName'),
            "doorIndexCodes"=> $request->input('doorIndexCodes'),
            "pageNo"=> 1,
            "pageSize"=> 10,
            "temperatureStatus"=> -1,
            "maskStatus"=> -1
        ]);

        // Generate Content-MD5
        $contentMd5 = base64_encode(md5($body, true));

        // Create the string to sign
        $stringToSign = "{$method}\n" .
                        "*/*\n" .
                        "{$contentMd5}\n" .
                        "{$contentType}\n" .
                        "{$date}\n" .
                        "x-ca-key:{$appKey}\n" .
                        "x-ca-timestamp:" . now()->timestamp * 1000 . "\n" .
                        $uri;

        // Generate the HmacSHA256 signature
        $signature = base64_encode(hash_hmac('sha256', $stringToSign, $appSecret, true));
        
        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, [
                'headers' => [
                    'Accept' => '*/*',
                    'Content-MD5' => $contentMd5,
                    'Content-Type' => $contentType,
                    'Date' => $date,
                    'X-Ca-Key' => $appKey,
                    'X-Ca-Signature' => $signature,
                    'X-Ca-Timestamp' => now()->timestamp * 1000,
                    'X-Ca-Signature-Headers' => 'x-ca-key,x-ca-timestamp',
                ],
                'body' => $body,
            ]);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    });
    Route::post('/artemis/api/acs/v1/faceCheck', function (Request $request) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $appKey = env('HIKCENTRAL_APP_KEY');
        $appSecret = env('HIKCENTRAL_APP_SECRET');
        $method = 'POST';
        $contentType = 'application/json';
        $date = Carbon::now('GMT')->format('D, d M Y H:i:s \G\M\T');
        $uri = '/artemis/api/acs/v1/faceCheck';
        $body = json_encode([
            "faceData"=> $request->input('faceData'),
            "acsDevIndexCode"=> "7"
        ]);

        // Generate Content-MD5
        $contentMd5 = base64_encode(md5($body, true));

        // Create the string to sign
        $stringToSign = "{$method}\n" .
                        "*/*\n" .
                        "{$contentMd5}\n" .
                        "{$contentType}\n" .
                        "{$date}\n" .
                        "x-ca-key:{$appKey}\n" .
                        "x-ca-timestamp:" . now()->timestamp * 1000 . "\n" .
                        $uri;

        // Generate the HmacSHA256 signature
        $signature = base64_encode(hash_hmac('sha256', $stringToSign, $appSecret, true));
        
        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, [
                'headers' => [
                    'Accept' => '*/*',
                    'Content-MD5' => $contentMd5,
                    'Content-Type' => $contentType,
                    'Date' => $date,
                    'X-Ca-Key' => $appKey,
                    'X-Ca-Signature' => $signature,
                    'X-Ca-Timestamp' => now()->timestamp * 1000,
                    'X-Ca-Signature-Headers' => 'x-ca-key,x-ca-timestamp',
                ],
                'body' => $body,
            ]);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    });
});

require __DIR__.'/auth.php';
