<?php $__env->startSection('script'); ?>
    <style>
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('attendance-button-class', 'active'); ?>

<?php $__env->startSection('tab-name', 'Attendance'); ?>

<?php $__env->startSection('header-left'); ?>
    <div onclick="add_attendance_click('add-popup')" class="h-10 bg-plt1 d-flex ai-center fs-12 fw-bold pd-10 pd-l-5 br-5 clr-white cursor-pointer"><span class="material-symbols-outlined mg-r-5 fw-bold">add</span>Add</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main-body'); ?>
    <div id="personal" class="tab active h-100p w-100p of-auto">
        <div class="of-auto">
            <table class="table-1 mg-40">
                <tr>
                    <th></th>
                    <th>Name</th>
                    <th>Start</th>
                    <th>End</th>
                    <th>Description</th>
                    <th>Location</th>
                    <th>Remark</th>
                    <th>Status</th>
                </tr>

                <?php $counter = 1; ?>
                <?php $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <div class="d-flex-center">
                                <div class="theme-primary-2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4"><?php echo e($counter); ?></div>
                            </div>
                        </td>
                        <td>
                            <div class="d-flex">
                                <div class="d-flex-center">
                                    <div class="d-flex-center br-50p bg-plt1 w-40 h-40">
                                        <?php if($attendance['user']['profile_picture_path']): ?>
                                            <img src="<?php echo e(asset('storage' . $attendance['user']['profile_picture_path'])); ?>" alt="" class="w-100p h-100p br-50p" style="object-fit:cover;border:none;">
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="mg-l-15 fs-12 fw-bold">
                                    <div class="" style="text-transform: uppercase;">
                                        <?php echo e($attendance['user']['name']); ?>

                                    </div>
                                    <div class="clr-grey-2 mg-t-5">
                                        <?php echo e($attendance['user']['position']); ?>

                                    </div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div class="fs-12 clr-grey-1 tw-nowrap">
                                <div><?php echo e(date('d F Y', strtotime($attendance['start']))); ?></div>
                                <div><?php echo e(date('h:i A', strtotime($attendance['start']))); ?></div>
                            </div>
                        </td>
                        <td>
                            <div class="fs-12 clr-grey-1 tw-nowrap">
                                <?php if($attendance['end']): ?>
                                    <div><?php echo e(date('d F Y', strtotime($attendance['end']))); ?></div>
                                    <div><?php echo e(date('h:i A', strtotime($attendance['end']))); ?></div>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td>
                            <div class="fs-12 clr-grey-1"><?php echo e($attendance['description']); ?></div>
                        </td>
                        <td>
                            <div class="fs-12 clr-grey-1"><?php echo e($attendance['location']); ?></div>
                        </td>
                        <td>
                            <div class="fs-12 clr-grey-1"><?php echo e($attendance['remark']); ?></div>
                        </td>
                        <td>
                            <?php
                                if ($attendance['status'] == 'On Time') {
                                    echo "<div class='pd-5 br-4 txt-c fs-11 fw-bold clr-green bg-green-lite'>On Time</div>";
                                } elseif ($attendance['status'] == 'Late Check-In' || $attendance['status'] == 'Early Check-Out' || $attendance['status'] == 'No Check-Out') {
                                    echo "<div class='pd-5 br-4 txt-c fs-11 fw-bold clr-yellow bg-yellow-lite'>" . $attendance['status'] . "</div>";
                                } else {
                                    echo "<div class='pd-5 br-4 txt-c fs-11 fw-bold clr-red bg-red-lite'>Absent</div>";
                                }
                            ?>
                        </td>
                    </tr>
                    <?php $counter++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-box'); ?>
    <div id="add-popup" class="right-popup bg-primary w-600 h-100p of-auto">
        <form  action="<?php echo e(route('attendance.create')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('POST'); ?>

        <div class="content w-100p" style="height: calc(100% - 80px);">
            <div class="h-100p pd-30"  style="width: calc(100% - 60px);">
                <div class="fs-18 clr-grey-2 fw-bold">New Attendance</div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-30">User <span style="color:red;">*</span></div>
                <button type="button" id="user-name-dropdown-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-8 pd-lr-0"><?php echo e(strtoupper($users[0]['name'])); ?></button>
                <input type="hidden" id="user-name-input" name="user_id" value="<?php echo e(strtoupper($users[0]['id'])); ?>">
                <div id="user-name-dropdown" class="dropdown w-300 pd-b-10">
                    <div class="d-flex">
                        <input type="text" name="" id="user-name-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                        <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                    </div>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="option fs-12 clr-grey-1 cursor-default" onclick="foreign_data_option_click('user-name-dropdown-button', 'user-name-dropdown', 'user-name-input', this.textContent, <?php echo e($user); ?>)"><?php echo e(strtoupper($user['name'])); ?></div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Date <span style="color:red;">*</span></div>
                <button type="button" id="start-date-dropdown-button" class="dropdown-button-1 w-300 clr-black-1 pd-tb-8 pd-lr-0"></button>
                <input type="hidden" id="start-date-time-input" name="start" value="<?php echo e(date('Y-m-d')); ?> 08:00:00">
                <div id="start-date-dropdown" class="calendar-container">
                    <div class="calendar-header">
                        <button type="button" class="previous-month br-50p w-25 h-25 d-flex-center cursor-pointer bg-plt1" style="border:none;"><span class="material-symbols-outlined fw-bold clr-white">chevron_left</span></button>
                        <span class="current-month-year fs-14 fw-bold"></span>
                        <button type="button" class="next-month br-50p w-25 h-25 d-flex-center cursor-pointer bg-plt1" style="border:none;"><span class="material-symbols-outlined fw-bold clr-white">chevron_right</span></button>
                    </div>
                    <div class="calendar-days"></div>
                </div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Time <span style="color:red;">*</span></div>
                <div class="d-flex">
                    <div>
                        <button type="button" id="start-time-hour-dropdown-button" class="dropdown-button-1 w-96 clr-black-1 pd-tb-8 pd-lr-0">08</button>
                        <div id="start-time-hour-dropdown" class="dropdown w-96 pd-b-10">
                            <?php for($i = 1; $i <= 12; $i++): ?>
                                <div class="option fs-12 clr-grey-1 cursor-default" onclick="time_option_click('start-time-hour-dropdown-button', 'start-time-minute-dropdown-button', 'start-time-phase-dropdown-button', 'start-time-hour-dropdown', 'start-date-time-input', this.textContent, 'hour')"><?php echo e(sprintf('%02d', $i)); ?></div>
                            <?php endfor; ?>
                        </div>
                    </div>
                    
                    <div>
                        <button type="button" id="start-time-minute-dropdown-button" class="dropdown-button-1 w-96 mg-l-6 clr-black-1 pd-tb-8 pd-lr-0">00</button>
                        <div id="start-time-minute-dropdown" class="dropdown w-96 mg-l-6 pd-b-10">
                            <?php for($i = 0; $i <= 59; $i++): ?>
                                <div class="option fs-12 clr-grey-1 cursor-default" onclick="time_option_click('start-time-hour-dropdown-button', 'start-time-minute-dropdown-button', 'start-time-phase-dropdown-button', 'start-time-minute-dropdown', 'start-date-time-input', this.textContent, 'minute')"><?php echo e(sprintf('%02d', $i)); ?></div>
                            <?php endfor; ?>
                        </div>
                    </div>

                    <div>
                        <button type="button" id="start-time-phase-dropdown-button" class="dropdown-button-1 w-96 mg-l-6 clr-black-1 pd-tb-8 pd-lr-0">AM</button>
                        <div id="start-time-phase-dropdown" class="dropdown w-96 mg-l-6 pd-b-10">
                            <div class="option fs-12 clr-grey-1 cursor-default" onclick="time_option_click('start-time-hour-dropdown-button', 'start-time-minute-dropdown-button', 'start-time-phase-dropdown-button', 'start-time-phase-dropdown', 'start-date-time-input', this.textContent, 'phase')">AM</div>
                            <div class="option fs-12 clr-grey-1 cursor-default" onclick="time_option_click('start-time-hour-dropdown-button', 'start-time-minute-dropdown-button', 'start-time-phase-dropdown-button', 'start-time-phase-dropdown', 'start-date-time-input', this.textContent, 'phase')">PM</div>
                        </div>
                    </div>
                </div>
                
                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Description <span style="color:red;">*</span></div>
                <textarea class="textarea-1 w-300 h-100 mg-t-8 br-2" style="max-width:300px;min-width:300px;font-family:Arial" name="description"></textarea>

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Check In Location</div>
                <input type="text" id="" name="location" class="dropdown-button-1 w-300 clr-black-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">

            </div>
        </div>
        <div class="submit-section h-80 w-100p">
            <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                <button type="submit" class="bg-btn-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                <button type="button" onclick="cancel_add_attendance_click('add-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
            </div>
        </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        function add_attendance_click(popup_id) {
            document.getElementById(popup_id).classList.add('active');
            document.getElementById('transparent').classList.add('active');
        }

        function cancel_add_attendance_click(popup_id) {
            document.getElementById(popup_id).classList.remove('active');
            document.getElementById('transparent').classList.remove('active');
        }

        function add_search(input_id, dropdown_id){
            document.getElementById(input_id).addEventListener('input', function() {
                const input = this.value.toLowerCase();
                const options = document.querySelectorAll('#' + dropdown_id + ' .option');
                options.forEach(function(option) {
                    if (option.textContent.toLowerCase().includes(input)) {
                        option.style.display = '';
                    } else {
                        option.style.display = 'none';
                    }
                });
            });
        }

        add_search('user-name-search', 'user-name-dropdown');

        function add_dropdown_event(button_id, dropdown_id){
            let button_element = document.getElementById(button_id);
            let dropdown_element = document.getElementById(dropdown_id);
            button_element.addEventListener('click', (e) => {
                dropdown_element.classList.toggle('active');
                button_element.classList.toggle('active');
            });
            window.addEventListener('blur', (e) => {
                dropdown_element.classList.remove('active');
                button_element.classList.remove('active');
            });
            dropdown_element.addEventListener('click', (event) => {
                event.stopPropagation();
            });
            document.addEventListener('click', (event) => {
                if (!button_element.contains(event.target)) {
                    dropdown_element.classList.remove('active');
                    button_element.classList.remove('active');
                }
            });
        }
        
        add_dropdown_event('user-name-dropdown-button', 'user-name-dropdown');
        add_dropdown_event('start-date-dropdown-button', 'start-date-dropdown');
        add_dropdown_event('start-time-hour-dropdown-button', 'start-time-hour-dropdown');
        add_dropdown_event('start-time-minute-dropdown-button', 'start-time-minute-dropdown');
        add_dropdown_event('start-time-phase-dropdown-button', 'start-time-phase-dropdown');
        
        function date_option_click(button_id, dropdown_id, input_id, value, date){
            option_click(button_id, dropdown_id, value);
            
            const year = date.getFullYear();
            const month = String(date.getMonth() + 1).padStart(2, '0');
            const day = String(date.getDate()).padStart(2, '0');
            const formattedDate = `${year}-${month}-${day}`;

            dateTime = document.getElementById(input_id).value;
            const timePart = dateTime.split(' ')[1]
            const updatedDateTime = `${formattedDate} ${timePart}`;
            document.getElementById(input_id).value = updatedDateTime;
        }

        function time_option_click(button_hour_id, button_minute_id, button_phase_id, dropdown_id, input_id, value, time_type){
            switch (time_type){
                case 'hour': option_click(button_hour_id, dropdown_id, value); break;
                case 'minute': option_click(button_minute_id, dropdown_id, value); break;
                case 'phase': option_click(button_phase_id, dropdown_id, value); break;
            }
            let hour = document.getElementById(button_hour_id).textContent;
            let minute = document.getElementById(button_minute_id).textContent;
            let phase = document.getElementById(button_phase_id).textContent;
            if (hour === '12') {hour = '00';}
            if (phase === 'PM') {hour = String(parseInt(hour, 10) + 12);}
            formattedTime = `${hour}:${minute}:00`;

            dateTime = document.getElementById(input_id).value;
            const datePart = dateTime.split(' ')[0];
            const updatedDateTime = `${datePart} ${formattedTime}`;
            document.getElementById(input_id).value = updatedDateTime;
        }

        function foreign_data_option_click(button_id, dropdown_id, input_id, value, foreign_data){
            option_click(button_id, dropdown_id, value);
            document.getElementById(input_id).value = foreign_data.id;
        }

        function option_click(button_id, dropdown_id, value){
            const button = document.getElementById(button_id);
            const dropdown = document.getElementById(dropdown_id);

            button.classList.remove('active');
            dropdown.classList.remove('active');
            button.textContent  = value;
        }


        function render_calendar(button_id, dropdown_id, input_id, date) {
            const current_month_year = document.querySelector('#' + dropdown_id + ' .current-month-year');
            const calendar_days = document.querySelector('#' + dropdown_id + ' .calendar-days');

            calendar_days.innerHTML = '';

            day_name = ['S','M','T','W','T','F','S'];
            for (let i = 0; i < day_name.length; i++) {
                const day = document.createElement('div');
                day.textContent = day_name[i];
                day.className = 'fw-bold';
                calendar_days.appendChild(day);
            }
            current_month_year.textContent = `${date.toLocaleString('default', { month: 'long' })} ${date.getFullYear()}`;
            const firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
            const lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            const startDay = firstDay.getDay();
            const endDay = lastDay.getDate();
            for (let i = 0; i < startDay; i++) {
                calendar_days.appendChild(document.createElement('div'));
            }
            const options = { weekday:'long', day:'numeric', month:'long', year:'numeric' };
            for (let i = 1; i <= endDay; i++) {
                const dayElement = document.createElement('div');
                dayElement.textContent = i;

                const date_copy = new Date(date.getFullYear(), date.getMonth(), i);
                const dateFormatter = new Intl.DateTimeFormat('en-GB', options);
                const parts = dateFormatter.formatToParts(date_copy);
                const dayName = parts.find(part => part.type === 'weekday').value;
                const day = parts.find(part => part.type === 'day').value;
                const month = parts.find(part => part.type === 'month').value;
                const year = parts.find(part => part.type === 'year').value;
                const formattedDate = `${dayName}, ${day} ${month} ${year}`;

                dayElement.addEventListener('click', function() {
                    date_option_click(button_id, dropdown_id, input_id, formattedDate, date_copy);
                });
                dayElement.className = 'clr-grey-1'
                dayElement.classList.add('valid');
                calendar_days.appendChild(dayElement);
            }
        }

        function add_calendar(button_id, dropdown_id, input_id){
            date = new Date()
            render_calendar(button_id, dropdown_id, input_id, date);
            const previous_month_button = document.querySelector('#' + dropdown_id + ' .previous-month');
            const next_month_button = document.querySelector('#' + dropdown_id + ' .next-month');
            previous_month_button.addEventListener('click', function() { 
                date.setMonth(date.getMonth() - 1);
                render_calendar(button_id, dropdown_id, input_id, date);
            });
            next_month_button.addEventListener('click', function() { 
                date.setMonth(date.getMonth() + 1);
                render_calendar(button_id, dropdown_id, input_id, date);
            });

            const options = { weekday:'long', day:'numeric', month:'long', year:'numeric' };
            const date_copy = new Date();
            const dateFormatter = new Intl.DateTimeFormat('en-GB', options);
            const parts = dateFormatter.formatToParts(date_copy);
            const dayName = parts.find(part => part.type === 'weekday').value;
            const day = parts.find(part => part.type === 'day').value;
            const month = parts.find(part => part.type === 'month').value;
            const year = parts.find(part => part.type === 'year').value;
            const formattedDate = `${dayName}, ${day} ${month} ${year}`;
            document.getElementById(button_id).textContent = formattedDate;
        }
        
        add_calendar('start-date-dropdown-button', 'start-date-dropdown', 'start-date-time-input');

    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Acer\Desktop\BIG PROJECTS\Attendance_System\resources\views/attendance.blade.php ENDPATH**/ ?>