<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Client extends ClientsController
{
    public function dlv($id, $hash)
    {
        check_delivery_note_restrictions($id, $hash);
        $delivery_note = $this->delivery_notes_model->get($id);

        if (!is_client_logged_in()) {
            load_client_language($delivery_note->clientid);
        }

        $identity_confirmation_enabled = get_option('delivery_note_accept_identity_confirmation');

        // Handle Estimate PDF generator
        if ($this->input->post('delivery_notepdf')) {
            try {
                $pdf = delivery_note_pdf($delivery_note);
            } catch (Exception $e) {
                echo $e->getMessage();
                die;
            }

            $delivery_note_number = format_delivery_note_number($delivery_note->id);
            $companyname     = get_option('invoice_company_name');
            if ($companyname != '') {
                $delivery_note_number .= '-' . mb_strtoupper(slug_it($companyname), 'UTF-8');
            }

            $filename = hooks()->apply_filters('customers_area_download_delivery_note_filename', mb_strtoupper(slug_it($delivery_note_number), 'UTF-8') . '.pdf', $delivery_note);

            $pdf->Output($filename, 'D');
            die();
        }
        $this->load->library('app_number_to_word', [
            'clientid' => $delivery_note->clientid,
        ], 'numberword');

        $this->app_scripts->theme('sticky-js', 'assets/plugins/sticky/sticky.js');

        $data['title'] = format_delivery_note_number($delivery_note->id);
        $this->disableNavigation();
        $this->disableSubMenu();
        $data['hash']                          = $hash;
        $data['can_be_accepted']               = false;
        $data['delivery_note']                      = hooks()->apply_filters('delivery_note_html_pdf_data', $delivery_note);
        $data['bodyclass']                     = 'viewdelivery_note';
        $data['identity_confirmation_enabled'] = $identity_confirmation_enabled;
        if ($identity_confirmation_enabled == '1') {
            $data['bodyclass'] .= ' identity-confirmation';
        }
        $this->data($data);
        $this->view('client/delivery_notehtml', $data, true);
        add_views_tracking('delivery_note', $id);
        hooks()->do_action('delivery_note_html_viewed', $id);
        no_index_customers_area();
        $this->layout();
    }
}
