<?php

defined('BASEPATH') or exit('No direct script access allowed');

include_once(LIBSPATH . 'pdf/App_pdf.php');

class delivery_note_pdf extends App_pdf
{
    protected $delivery_note;

    private $delivery_note_number;

    public function __construct($delivery_note, $tag = '')
    {
        $this->load_language($delivery_note->clientid);

        $delivery_note                = hooks()->apply_filters('delivery_note_html_pdf_data', $delivery_note);
        $GLOBALS['delivery_note_pdf'] = $delivery_note;

        parent::__construct();

        $this->tag             = $tag;
        $this->delivery_note        = $delivery_note;
        $this->delivery_note_number = format_delivery_note_number($this->delivery_note->id);

        $this->SetTitle($this->delivery_note_number);
    }

    public function prepare()
    {
        $this->with_number_to_word($this->delivery_note->clientid);

        $this->set_view_vars([
            'status'          => $this->delivery_note->status,
            'delivery_note_number' => $this->delivery_note_number,
            'delivery_note'        => $this->delivery_note,
        ]);

        return $this->build();
    }

    protected function type()
    {
        return 'delivery_note';
    }

    protected function file_path()
    {
        return module_dir_path(DELIVERY_NOTE_MODULE_NAME, 'views/pdf/delivery_note_pdf.php');
    }
}
