<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Verify\V2\Service;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

class VerificationList extends ListResource {
    /**
     * Construct the VerificationList
     *
     * @param Version $version Version that contains the resource
     * @param string $serviceSid The SID of the Service that the resource is
     *                           associated with
     */
    public function __construct(Version $version, string $serviceSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['serviceSid' => $serviceSid, ];

        $this->uri = '/Services/' . \rawurlencode($serviceSid) . '/Verifications';
    }

    /**
     * Create the VerificationInstance
     *
     * @param string $to The phone number or email to verify
     * @param string $channel The verification method to use
     * @param array|Options $options Optional Arguments
     * @return VerificationInstance Created VerificationInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(string $to, string $channel, array $options = []): VerificationInstance {
        $options = new Values($options);

        $data = Values::of([
            'To' => $to,
            'Channel' => $channel,
            'CustomFriendlyName' => $options['customFriendlyName'],
            'CustomMessage' => $options['customMessage'],
            'SendDigits' => $options['sendDigits'],
            'Locale' => $options['locale'],
            'CustomCode' => $options['customCode'],
            'Amount' => $options['amount'],
            'Payee' => $options['payee'],
            'RateLimits' => Serialize::jsonObject($options['rateLimits']),
            'ChannelConfiguration' => Serialize::jsonObject($options['channelConfiguration']),
            'AppHash' => $options['appHash'],
        ]);

        $payload = $this->version->create('POST', $this->uri, [], $data);

        return new VerificationInstance($this->version, $payload, $this->solution['serviceSid']);
    }

    /**
     * Constructs a VerificationContext
     *
     * @param string $sid The unique string that identifies the resource
     */
    public function getContext(string $sid): VerificationContext {
        return new VerificationContext($this->version, $this->solution['serviceSid'], $sid);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Verify.V2.VerificationList]';
    }
}