<?php

defined('BASEPATH') or exit('No direct script access allowed');
// Font Weight Options
$font_weight_options = array(
    array('value' => 'normal', 'name' => _l('custom_sales_normal')),
    array('value' => 'bold', 'name' => _l('custom_sales_bold')),
    array('value' => 'bolder', 'name' => _l('custom_sales_bolder')),
    array('value' => 'lighter', 'name' => _l('custom_sales_lighter')),
);

// Border Style Options
$border_style_options = array(
    array('value' => 'solid', 'name' => _l('custom_sales_solid')),
    array('value' => 'dashed', 'name' => _l('custom_sales_dashed')),
    array('value' => 'dotted', 'name' => _l('custom_sales_dotted')),
);

// Border Location Options
$border_location_options = array(
    array('value' => 'bottom', 'name' => _l('custom_sales_bottom')),
    array('value' => 'top', 'name' => _l('custom_sales_top')),
);

$items_types = custom_sales_get_item_types(true);

// Items fields
$item_fields_options = array(
    array('value' => 'qty', 'name' => _l('invoice_table_quantity_heading', '', false)),
    array('value' => 'rate', 'name' => _l('invoice_table_rate_heading', '', false)),
    array('value' => 'amount', 'name' => _l('invoice_table_amount_heading', '', false)),
    array('value' => 'tax', 'name' => _l('invoice_table_tax_heading', '', false)),
    array('value' => 'long_description', 'name' => _l('invoice_item_long_description', '', false)),
);

$options_entry = ['value', ['name']];

$groups = ['html', 'pdf'];

$styles = get_option('custom_sales_item_title_styles');
$styles = empty($styles) ? [] : json_decode($styles, true);
?>
<div class="tw-flex tw-flex-col">

    <div>
        <h4><?= _l('custom_sales_settings_deposit_invoice'); ?></h4>
        <hr />

        <?php $key = 'custom_sales_allow_deposit_invoice'; ?>
        <?= render_yes_no_option($key, $key, $key . '_hint'); ?>

        <?php
        $key = 'custom_sales_max_deposit_invoice';
        $value = (int)get_option($key);
        $label = _l($key) . ' <i class="fa fa-question-circle" data-toggle="tooltip" data-title="' . _l($key . '_hint') . '"></i>';
        ?>
        <?= render_input('settings[' . $key . ']', $label, ($value > 1 ? $value : 5), 'number', ['min' => 2, 'step' => 1]); ?>

        <?php $key = 'custom_sales_disable_updating_deposit_invoice'; ?>
        <?= render_yes_no_option($key, $key, $key . '_hint'); ?>

        <?php $key = 'custom_sales_hide_pricing_on_deposit_invoice'; ?>
        <?= render_yes_no_option($key, $key); ?>

    </div>

    <div class="tw-mt-4 tw-mb-4">
        <hr />
    </div>

    <div>
        <h4><?= _l('custom_sales_settings_items_field'); ?></h4>
        <hr />

        <?php
        $items_types = hooks()->apply_filters('custom_sales_configurable_item_types', $items_types);
        foreach ($items_types as $type) : ?>
            <?php
            $label_key = $type == 'deposit_invoice' ? 'custom_sales_client_items_hidden_field_for_all' : 'custom_sales_client_items_hidden_field';
            $key = 'custom_sales_client_items_hidden_field_for_' . $type;

            $label = _l($label_key, _l($type)) . ' <i class="fa fa-question-circle" data-toggle="tooltip" data-title="' . _l($label_key . '_hint', _l($type)) . '"></i>';
            $value = custom_sales_client_hidden_fields($type);
            ?>

            <?php echo render_select('settings[' . $key . '][]', $item_fields_options, $options_entry, $label, $value, ['multiple' => true], [], '', '', true); ?>

        <?php endforeach; ?>
    </div>

    <div class="tw-mt-4 tw-mb-4">
        <hr />
    </div>

    <?php foreach ($groups as $group) : ?>
        <div>
            <h4><?= _l('custom_sales_settings_' . $group); ?></h4>
            <hr />
            <div class="row">

                <?php
                $key = 'color';
                $label =  'custom_sales_text_color';
                $name = 'settings[custom_sales_item_title_styles][' . $group . '][' . $key . ']';
                $value = $styles[$group][$key] ?? '#000000';
                ?>
                <div class="col-md-6">
                    <?php echo render_input($name, $label, $value, 'color'); ?>
                </div>

                <?php
                $key = 'font-weight';
                $label =  'custom_sales_font_weight';
                $name = 'settings[custom_sales_item_title_styles][' . $group . '][' . $key . ']';
                $value = $styles[$group][$key] ?? 'bold';
                ?>
                <div class="col-md-6">
                    <?php echo render_select($name, $font_weight_options, $options_entry, $label, $value, [], [], '', '', false); ?>
                </div>

                <?php
                $key = 'font-size';
                $label =  'custom_sales_font_size';
                $name = 'settings[custom_sales_item_title_styles][' . $group . '][' . $key . ']';
                $value = $styles[$group][$key] ?? '16';
                ?>
                <div class="col-md-6">
                    <?php echo render_input($name, _l($label) . ' (px)', $value, 'number', array('min' => '1', 'step' => '1')); ?>
                </div>

                <?php
                $key = 'border-size';
                $label =  'custom_sales_border_size';
                $name = 'settings[custom_sales_item_title_styles][' . $group . '][' . $key . ']';
                $value = $styles[$group][$key] ?? '1';
                ?>
                <div class="col-md-6">
                    <?php echo render_input($name, _l($label) . ' (px)', $value, 'number', array('min' => '1', 'step' => '1')); ?>
                </div>

                <?php
                $key = 'border-color';
                $label =  'custom_sales_border_color';
                $name = 'settings[custom_sales_item_title_styles][' . $group . '][' . $key . ']';
                $value = $styles[$group][$key] ?? '#000000';
                ?>
                <div class="col-md-6">
                    <?php echo render_input($name, $label, $value, 'color'); ?>
                </div>

                <?php
                $key = 'border-style';
                $label =  'custom_sales_border_style';
                $name = 'settings[custom_sales_item_title_styles][' . $group . '][' . $key . ']';
                $value = $styles[$group][$key] ?? 'solid';
                ?>
                <div class="col-md-6">
                    <?php echo render_select($name, $border_style_options, $options_entry, $label, $value, [], [], '', '', false); ?>
                </div>

                <?php
                $key = 'border_location';
                $label =  'custom_sales_border_location';
                $name = 'settings[custom_sales_item_title_styles][' . $group . '][' . $key . ']';
                $value = $styles[$group][$key] ?? 'bottom';
                ?>
                <div class="col-md-6">
                    <?php echo render_select($name, $border_location_options, $options_entry, $label, $value, [], [], '', '', false); ?>
                </div>

            </div>

        </div>


        <div class="tw-mt-4 tw-mb-4">
            <hr />
        </div>
    <?php endforeach; ?>

</div>