<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div role="tabpanel" class="tab-pane" id="delivery_notes">
    <div class="form-group">
        <label class="control-label" for="delivery_note_prefix"><?php echo _l('settings_sales_delivery_note_prefix'); ?></label>
        <input type="text" name="settings[delivery_note_prefix]" class="form-control" value="<?php echo get_option('delivery_note_prefix'); ?>">
    </div>
    <hr />
    <i class="fa-regular fa-circle-question pull-left tw-mt-0.5 tw-mr-1" data-toggle="tooltip" data-title="<?php echo _l('settings_sales_next_delivery_note_number_tooltip'); ?>"></i>
    <?php echo render_input('settings[next_delivery_note_number]', 'settings_sales_next_delivery_note_number', get_option('next_delivery_note_number'), 'number', ['min' => 1]); ?>
    <hr />

    <?php render_yes_no_option('delete_only_on_last_delivery_note', 'settings_delete_only_on_last_delivery_note'); ?>
    <hr />
    <?php render_yes_no_option('delivery_note_number_decrement_on_delete', 'settings_sales_decrement_delivery_note_number_on_delete', 'settings_sales_decrement_delivery_note_number_on_delete_tooltip'); ?>
    <hr />
    <?php echo render_yes_no_option('allow_staff_view_delivery_notes_assigned', 'allow_staff_view_delivery_notes_assigned'); ?>
    <hr />

    <?php render_yes_no_option('view_delivery_note_only_logged_in', 'settings_sales_require_client_logged_in_to_view_delivery_note'); ?>
    <hr />
    <?php render_yes_no_option('show_sale_agent_on_delivery_notes', 'settings_show_sale_agent_on_delivery_notes'); ?>
    <hr />
    <?php render_yes_no_option('show_project_on_delivery_note', 'show_project_on_delivery_note'); ?>
    <hr />
    <?php render_yes_no_option('delivery_note_auto_convert_to_invoice_on_staff_delivered', 'settings_delivery_note_auto_convert_to_invoice_on_staff_delivered'); ?>
    <hr />
    <div class="form-group">
        <label for="delivery_note_number_format" class="control-label clearfix"><?php echo _l('settings_sales_delivery_note_number_format'); ?></label>
        <div class="radio radio-primary radio-inline">
            <input type="radio" name="settings[delivery_note_number_format]" value="1" id="e_number_based" <?php if (get_option('delivery_note_number_format') == '1') {
                                                                                                                echo 'checked';
                                                                                                            } ?>>
            <label for="e_number_based"><?php echo _l('settings_sales_delivery_note_number_format_number_based'); ?></label>
        </div>
        <div class="radio radio-primary radio-inline">
            <input type="radio" name="settings[delivery_note_number_format]" value="2" id="e_year_based" <?php if (get_option('delivery_note_number_format') == '2') {
                                                                                                                echo 'checked';
                                                                                                            } ?>>
            <label for="e_year_based"><?php echo _l('settings_sales_delivery_note_number_format_year_based'); ?>
                (YYYY/000001)</label>
        </div>
        <div class="radio radio-primary radio-inline">
            <input type="radio" name="settings[delivery_note_number_format]" value="3" id="e_short_year_based" <?php if (get_option('delivery_note_number_format') == '3') {
                                                                                                                    echo 'checked';
                                                                                                                } ?>>
            <label for="e_short_year_based">000001-YY</label>
        </div>
        <div class="radio radio-primary radio-inline">
            <input type="radio" name="settings[delivery_note_number_format]" value="4" id="e_year_month_based" <?php if (get_option('delivery_note_number_format') == '4') {
                                                                                                                    echo 'checked';
                                                                                                                } ?>>
            <label for="e_year_month_based">000001/MM/YYYY</label>
        </div>
        <hr />
    </div>
    <div class="row">
        <div class="col-md-12">
            <?php echo render_input('settings[delivery_notes_pipeline_limit]', 'pipeline_limit_status', get_option('delivery_notes_pipeline_limit')); ?>
        </div>
        <div class="col-md-7">
            <label for="default_proposals_pipeline_sort" class="control-label"><?php echo _l('default_pipeline_sort'); ?></label>
            <select name="settings[default_delivery_notes_pipeline_sort]" id="default_delivery_notes_pipeline_sort" class="selectpicker" data-width="100%" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                <option value="datecreated" <?php if (get_option('default_delivery_notes_pipeline_sort') == 'datecreated') {
                                                echo 'selected';
                                            } ?>><?php echo _l('delivery_notes_sort_datecreated'); ?></option>
                <option value="date" <?php if (get_option('default_delivery_notes_pipeline_sort') == 'date') {
                                            echo 'selected';
                                        } ?>><?php echo _l('delivery_notes_sort_delivery_note_date'); ?></option>
                <option value="pipeline_order" <?php if (get_option('default_delivery_notes_pipeline_sort') == 'pipeline_order') {
                                                    echo 'selected';
                                                } ?>><?php echo _l('delivery_notes_sort_pipeline'); ?></option>
            </select>
        </div>
        <div class="col-md-5">
            <div class="mtop30 text-right">
                <div class="radio radio-inline radio-primary">
                    <input type="radio" id="k_desc_delivery_note" name="settings[default_delivery_notes_pipeline_sort_type]" value="asc" <?php if (get_option('default_delivery_notes_pipeline_sort_type') == 'asc') {
                                                                                                                                                echo 'checked';
                                                                                                                                            } ?>>
                    <label for="k_desc_delivery_note"><?php echo _l('order_ascending'); ?></label>
                </div>
                <div class="radio radio-inline radio-primary">
                    <input type="radio" id="k_asc_delivery_note" name="settings[default_delivery_notes_pipeline_sort_type]" value="desc" <?php if (get_option('default_delivery_notes_pipeline_sort_type') == 'desc') {
                                                                                                                                                echo 'checked';
                                                                                                                                            } ?>>
                    <label for="k_asc_delivery_note"><?php echo _l('order_descending'); ?></label>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
    </div>
    <hr />
    <?php echo render_textarea('settings[predefined_clientnote_delivery_note]', 'settings_predefined_clientnote', get_option('predefined_clientnote_delivery_note'), ['rows' => 6]); ?>
    <?php echo render_textarea('settings[predefined_terms_delivery_note]', 'settings_predefined_predefined_term', get_option('predefined_terms_delivery_note'), ['rows' => 6]); ?>
</div>