<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Insights\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class RoomOptions {
    /**
     * @param string[] $roomType The room_type
     * @param string[] $codec The codec
     * @param string $roomName The room_name
     * @param \DateTime $createdAfter The created_after
     * @param \DateTime $createdBefore The created_before
     * @return ReadRoomOptions Options builder
     */
    public static function read(array $roomType = Values::ARRAY_NONE, array $codec = Values::ARRAY_NONE, string $roomName = Values::NONE, \DateTime $createdAfter = Values::NONE, \DateTime $createdBefore = Values::NONE): ReadRoomOptions {
        return new ReadRoomOptions($roomType, $codec, $roomName, $createdAfter, $createdBefore);
    }
}

class ReadRoomOptions extends Options {
    /**
     * @param string[] $roomType The room_type
     * @param string[] $codec The codec
     * @param string $roomName The room_name
     * @param \DateTime $createdAfter The created_after
     * @param \DateTime $createdBefore The created_before
     */
    public function __construct(array $roomType = Values::ARRAY_NONE, array $codec = Values::ARRAY_NONE, string $roomName = Values::NONE, \DateTime $createdAfter = Values::NONE, \DateTime $createdBefore = Values::NONE) {
        $this->options['roomType'] = $roomType;
        $this->options['codec'] = $codec;
        $this->options['roomName'] = $roomName;
        $this->options['createdAfter'] = $createdAfter;
        $this->options['createdBefore'] = $createdBefore;
    }

    /**
     * The room_type
     *
     * @param string[] $roomType The room_type
     * @return $this Fluent Builder
     */
    public function setRoomType(array $roomType): self {
        $this->options['roomType'] = $roomType;
        return $this;
    }

    /**
     * The codec
     *
     * @param string[] $codec The codec
     * @return $this Fluent Builder
     */
    public function setCodec(array $codec): self {
        $this->options['codec'] = $codec;
        return $this;
    }

    /**
     * The room_name
     *
     * @param string $roomName The room_name
     * @return $this Fluent Builder
     */
    public function setRoomName(string $roomName): self {
        $this->options['roomName'] = $roomName;
        return $this;
    }

    /**
     * The created_after
     *
     * @param \DateTime $createdAfter The created_after
     * @return $this Fluent Builder
     */
    public function setCreatedAfter(\DateTime $createdAfter): self {
        $this->options['createdAfter'] = $createdAfter;
        return $this;
    }

    /**
     * The created_before
     *
     * @param \DateTime $createdBefore The created_before
     * @return $this Fluent Builder
     */
    public function setCreatedBefore(\DateTime $createdBefore): self {
        $this->options['createdBefore'] = $createdBefore;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Insights.V1.ReadRoomOptions ' . $options . ']';
    }
}