<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\TrustedComms\Business;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\ListResource;
use Twilio\Rest\Preview\TrustedComms\Business\Insights\ImpressionsRateList;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 *
 * @property ImpressionsRateList $impressionsRate
 * @method \Twilio\Rest\Preview\TrustedComms\Business\Insights\ImpressionsRateContext impressionsRate()
 */
class InsightsList extends ListResource {
    protected $_impressionsRate = null;

    /**
     * Construct the InsightsList
     *
     * @param Version $version Version that contains the resource
     * @param string $businessSid A string that uniquely identifies this Business.
     */
    public function __construct(Version $version, string $businessSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['businessSid' => $businessSid, ];
    }

    /**
     * Access the impressionsRate
     */
    protected function getImpressionsRate(): ImpressionsRateList {
        if (!$this->_impressionsRate) {
            $this->_impressionsRate = new ImpressionsRateList($this->version, $this->solution['businessSid']);
        }

        return $this->_impressionsRate;
    }

    /**
     * Magic getter to lazy load subresources
     *
     * @param string $name Subresource to return
     * @return \Twilio\ListResource The requested subresource
     * @throws TwilioException For unknown subresources
     */
    public function __get(string $name) {
        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown subresource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments): InstanceContext {
        $property = $this->$name;
        if (\method_exists($property, 'getContext')) {
            return \call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Preview.TrustedComms.InsightsList]';
    }
}