<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\Classes;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;

class ManageAccess extends Command
{
    protected $signature = 'app:manage-access';
    protected $description = 'Command description';

    public function handle()
    {
        $now = now();

        $minutesEarly = 30;
        $rangeTimeRevoke = 10;

        // $this->revokeAccess([['id'=>'61'], ['id'=>'62']]);dd();

        // Retrieve upcoming classes within the next 30 minutes
        $classes = Classes::where('start_date_time', '<=', $now->copy()->addMinutes($minutesEarly))->get()->where('end_date_time', '>=', $now->copy()->subMinutes($rangeTimeRevoke));

        foreach ($classes as $class) {
            $startDateTime = Carbon::parse($class->start_date_time);
            $endDateTime = Carbon::parse($class->end_date_time);
            $minutesBefore = $startDateTime->copy()->subMinutes($minutesEarly);
        
            if ($now->greaterThanOrEqualTo($minutesBefore) && $now->lessThan($endDateTime)) {
                // Trigger the task 30 minutes before the class starts

                $doorEnventFace = $this->getDoorEvent($minutesBefore->toIso8601String(), $endDateTime->toIso8601String(), 196893)->getData(true);
                $doorEnventCard = $this->getDoorEvent($minutesBefore->toIso8601String(), $endDateTime->toIso8601String(), 198914)->getData(true);
                $doorEnventFingerprint = $this->getDoorEvent($minutesBefore->toIso8601String(), $endDateTime->toIso8601String(), 197127)->getData(true);
                $hcp_ids = [];
                if (isset($doorEnventFace['data']['list'])) {
                    foreach($doorEnventFace['data']['list'] as $list) {
                        array_push($hcp_ids, $list['personId']);
                    }
                }

                if (isset($doorEnventCard['data']['list'])) {
                    foreach($doorEnventCard['data']['list'] as $list) {
                        array_push($hcp_ids, $list['personId']);
                    }
                }

                if (isset($doorEnventFingerprint['data']['list'])) {
                    foreach($doorEnventFingerprint['data']['list'] as $list) {
                        array_push($hcp_ids, $list['personId']);
                    }
                }
                $hcp_ids = array_unique($hcp_ids);


                $list = [];
                foreach($class->group->group_user as $group_user) {
                    $user = $group_user->user;
                    array_push($list, ['id' => strval($user->hcp_id)]);
                    $attendance = $user->attendances->where('class_id', $class->id);

                    if (in_array(strval($user->hcp_id), $hcp_ids)) {
                        if ($attendance->isEmpty()) {
                            $attendance = new \App\Models\Attendances();
                            $attendance->user_id = $user->id;
                            $attendance->class_id = $class->id;
                            $attendance->check_date_time = now();
                            $attendance->save();
                        }
                    }
                    
                }
                $this->assignAccess($list, strval($class->room->devices->first()->privilege_group_id));
                // dd('Assign Completed');
            } elseif ($now->greaterThanOrEqualTo($endDateTime)) {
                $list = [];
                foreach($class->group->group_user as $group_user) {
                    $user = $group_user->user;
                    array_push($list, ['id' => strval($user->hcp_id)]);
                }
                $this->revokeAccess($list, $class->room->devices->first()->privilege_group_id);
                // dd('Revoke Completed');
            }
        }
    }

    private function get_options($body, $uri) {
        $appKey = env('HIKCENTRAL_APP_KEY');
        $appSecret = env('HIKCENTRAL_APP_SECRET');
        $date = Carbon::now('GMT')->format('D, d M Y H:i:s \G\M\T');
        $method = 'POST';
        $contentType = 'application/json';

        // Generate Content-MD5
        $contentMd5 = base64_encode(md5($body, true));

        // Create the string to sign
        $stringToSign = "{$method}\n" .
                        "*/*\n" .
                        "{$contentMd5}\n" .
                        "{$contentType}\n" .
                        "{$date}\n" .
                        "x-ca-key:{$appKey}\n" .
                        "x-ca-timestamp:" . now()->timestamp * 1000 . "\n" .
                        $uri;

        // Generate the HmacSHA256 signature
        $signature = base64_encode(hash_hmac('sha256', $stringToSign, $appSecret, true));

        $options = [
            'headers' => [
                'Accept' => '*/*',
                'Content-MD5' => $contentMd5,
                'Content-Type' => $contentType,
                'Date' => $date,
                'X-Ca-Key' => $appKey,
                'X-Ca-Signature' => $signature,
                'X-Ca-Timestamp' => now()->timestamp * 1000,
                'X-Ca-Signature-Headers' => 'x-ca-key,x-ca-timestamp',
            ],
            'body' => $body,
        ];

        return $options;

    }

    public function revokeAccess($list, $privelege_group_id) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $uri = '/artemis/api/acs/v1/privilege/group/single/deletePersons';
        $body = json_encode([
            "privilegeGroupId" => $privelege_group_id,
            "type" => 1,
            "list" => $list,
        ]);
       
        $options = $this->get_options($body, $uri);
        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, $options);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    }

    public function assignAccess($list, $privelege_group_id) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $uri = '/artemis/api/acs/v1/privilege/group/single/addPersons';
        $body = json_encode([
            "privilegeGroupId" => $privelege_group_id,
            "type" => 1,
            "list" => $list,
        ]);
        
        $options = $this->get_options($body, $uri);
        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, $options);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    }

    function getDoorEvent($startTime, $endTime, $eventType) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $uri = '/artemis/api/acs/v1/door/events';
        $body = json_encode([
            "startTime"=> $startTime,
            "endTime"=> $endTime,
            "eventType"=> $eventType,
            "doorIndexCodes"=> ['3'],
            "pageNo"=> 1,
            "pageSize"=> 450,
            "temperatureStatus"=> -1,
            "maskStatus"=> -1
        ]);

        $options = $this->get_options($body, $uri);

        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, $options);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    }
}
